package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxNshc4CaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcNxNshc4CaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcNxNshc4CaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcNxNshc4CaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcNxNshc4CaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SrcNxNshc4CaseBuilder implements Builder<SrcNxNshc4Case> {

    private Empty _nxNshc4Dst;


    Map<Class<? extends Augmentation<SrcNxNshc4Case>>, Augmentation<SrcNxNshc4Case>> augmentation = Collections.emptyMap();

    public SrcNxNshc4CaseBuilder() {
    }
    
    
    
    public SrcNxNshc4CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping arg) {
        this._nxNshc4Dst = arg.getNxNshc4Dst();
    }
    

    public SrcNxNshc4CaseBuilder(SrcNxNshc4Case base) {
        Map<Class<? extends Augmentation<SrcNxNshc4Case>>, Augmentation<SrcNxNshc4Case>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxNshc4Dst = base.getNxNshc4Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping) {
            this._nxNshc4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping)arg).getNxNshc4Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping]");
    }

    public Empty getNxNshc4Dst() {
        return _nxNshc4Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNshc4Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrcNxNshc4CaseBuilder setNxNshc4Dst(final Empty value) {
        this._nxNshc4Dst = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrcNxNshc4CaseBuilder addAugmentation(Augmentation<SrcNxNshc4Case> augmentation) {
        Class<? extends Augmentation<SrcNxNshc4Case>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrcNxNshc4CaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshc4Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshc4Case build() {
        return new SrcNxNshc4CaseImpl(this);
    }

    private static final class SrcNxNshc4CaseImpl
        extends AbstractAugmentable<SrcNxNshc4Case>
        implements SrcNxNshc4Case {
    
        private final Empty _nxNshc4Dst;
    
        SrcNxNshc4CaseImpl(SrcNxNshc4CaseBuilder base) {
            super(base.augmentation);
            this._nxNshc4Dst = base.getNxNshc4Dst();
        }
    
        @Override
        public Empty getNxNshc4Dst() {
            return _nxNshc4Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SrcNxNshc4Case.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SrcNxNshc4Case.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SrcNxNshc4Case.bindingToString(this);
        }
    }
}
