package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NxResubmitBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxResubmitBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxResubmitBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxResubmitBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxResubmitBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxResubmitBuilder implements Builder<NxResubmit> {

    private Uint16 _inPort;
    private Uint8 _table;


    Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();

    public NxResubmitBuilder() {
    }
    
    

    public NxResubmitBuilder(NxResubmit base) {
        Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._inPort = base.getInPort();
        this._table = base.getTable();
    }


    public Uint16 getInPort() {
        return _inPort;
    }
    
    public Uint8 getTable() {
        return _table;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxResubmit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxResubmitBuilder setInPort(final Uint16 value) {
        this._inPort = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setInPort(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxResubmitBuilder setInPort(final Integer value) {
        return setInPort(CodeHelpers.compatUint(value));
    }
    
    private static void checkTableRange(final short value) {
    }
    
    public NxResubmitBuilder setTable(final Uint8 value) {
        if (value != null) {
            checkTableRange(value.shortValue());
            
        }
        this._table = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setTable(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxResubmitBuilder setTable(final Short value) {
        return setTable(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxResubmitBuilder addAugmentation(Augmentation<NxResubmit> augmentation) {
        Class<? extends Augmentation<NxResubmit>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxResubmitBuilder removeAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxResubmit build() {
        return new NxResubmitImpl(this);
    }

    private static final class NxResubmitImpl
        extends AbstractAugmentable<NxResubmit>
        implements NxResubmit {
    
        private final Uint16 _inPort;
        private final Uint8 _table;
    
        NxResubmitImpl(NxResubmitBuilder base) {
            super(base.augmentation);
            this._inPort = base.getInPort();
            this._table = base.getTable();
        }
    
        @Override
        public Uint16 getInPort() {
            return _inPort;
        }
        
        @Override
        public Uint8 getTable() {
            return _table;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxResubmit.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxResubmit.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxResubmit.bindingToString(this);
        }
    }
}
