package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-conntrack {
 *   leaf flags {
 *     type uint16;
 *   }
 *   leaf zone-src {
 *     type uint32;
 *   }
 *   leaf conntrack-zone {
 *     type uint16;
 *   }
 *   leaf recirc-table {
 *     type uint8;
 *   }
 *   list ct-actions {
 *     uses ofpact-actions;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping/nx-conntrack</i>
 *
 * <p>To create instances of this class use {@link NxConntrackBuilder}.
 * @see NxConntrackBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxConntrack
    extends
    ChildOf<NxActionConntrackGrouping>,
    Augmentable<NxConntrack>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-conntrack");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.@NonNull NxConntrack obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConntrackZone());
        result = prime * result + Objects.hashCode(obj.getCtActions());
        result = prime * result + Objects.hashCode(obj.getFlags());
        result = prime * result + Objects.hashCode(obj.getRecircTable());
        result = prime * result + Objects.hashCode(obj.getZoneSrc());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.@NonNull NxConntrack thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getConntrackZone(), other.getConntrackZone())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFlags(), other.getFlags())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRecircTable(), other.getRecircTable())) {
            return false;
        }
        if (!Objects.equals(thisObj.getZoneSrc(), other.getZoneSrc())) {
            return false;
        }
        if (!Objects.equals(thisObj.getCtActions(), other.getCtActions())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.@NonNull NxConntrack obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxConntrack");
        CodeHelpers.appendValue(helper, "conntrackZone", obj.getConntrackZone());
        CodeHelpers.appendValue(helper, "ctActions", obj.getCtActions());
        CodeHelpers.appendValue(helper, "flags", obj.getFlags());
        CodeHelpers.appendValue(helper, "recircTable", obj.getRecircTable());
        CodeHelpers.appendValue(helper, "zoneSrc", obj.getZoneSrc());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return flags, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint16} flags, or {@code null} if it is not present.
     *
     */
    Uint16 getFlags();
    
    /**
     * Return zoneSrc, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint32} zoneSrc, or {@code null} if it is not present.
     *
     */
    Uint32 getZoneSrc();
    
    /**
     * Return conntrackZone, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint16} conntrackZone, or {@code null} if it is not present.
     *
     */
    Uint16 getConntrackZone();
    
    /**
     * Return recircTable, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint8} recircTable, or {@code null} if it is not present.
     *
     */
    Uint8 getRecircTable();
    
    /**
     * Return ctActions, or {@code null} if it is not present.
     *
     * @return {@code java.util.List} ctActions, or {@code null} if it is not present.
     *
     */
    @Nullable List<CtActions> getCtActions();
    
    /**
     * Return ctActions, or an empty list if it is not present.
     *
     * @return {@code java.util.List} ctActions, or an empty list if it is not present.
     *
     */
    default @NonNull List<CtActions> nonnullCtActions() {
        return CodeHelpers.nonnull(getCtActions());
    }

}

