package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.flags.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NxmNxNshFlagsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmNxNshFlagsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmNxNshFlagsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmNxNshFlagsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmNxNshFlagsBuilder
 * @see Builder
 *
 */
public class NxmNxNshFlagsBuilder implements Builder<NxmNxNshFlags> {

    private Uint8 _mask;
    private Uint8 _nshFlags;


    Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> augmentation = Collections.emptyMap();

    public NxmNxNshFlagsBuilder() {
    }

    public NxmNxNshFlagsBuilder(NxmNxNshFlags base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> aug =((AugmentationHolder<NxmNxNshFlags>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mask = base.getMask();
        this._nshFlags = base.getNshFlags();
    }


    public Uint8 getMask() {
        return _mask;
    }
    
    public Uint8 getNshFlags() {
        return _nshFlags;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshFlags>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxmNxNshFlagsBuilder setMask(final Uint8 value) {
        this._mask = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setMask(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshFlagsBuilder setMask(final Short value) {
        return setMask(CodeHelpers.compatUint(value));
    }
    
    public NxmNxNshFlagsBuilder setNshFlags(final Uint8 value) {
        this._nshFlags = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setNshFlags(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshFlagsBuilder setNshFlags(final Short value) {
        return setNshFlags(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxmNxNshFlagsBuilder addAugmentation(Augmentation<NxmNxNshFlags> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public NxmNxNshFlagsBuilder addAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType, Augmentation<NxmNxNshFlags> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxmNxNshFlagsBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private NxmNxNshFlagsBuilder doAddAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType, Augmentation<NxmNxNshFlags> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public NxmNxNshFlags build() {
        return new NxmNxNshFlagsImpl(this);
    }

    private static final class NxmNxNshFlagsImpl
        extends AbstractAugmentable<NxmNxNshFlags>
        implements NxmNxNshFlags {
    
        private final Uint8 _mask;
        private final Uint8 _nshFlags;
    
        NxmNxNshFlagsImpl(NxmNxNshFlagsBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._nshFlags = base.getNshFlags();
        }
    
        @Override
        public Uint8 getMask() {
            return _mask;
        }
        
        @Override
        public Uint8 getNshFlags() {
            return _nshFlags;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(_nshFlags);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshFlags.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmNxNshFlags other = (NxmNxNshFlags)obj;
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(_nshFlags, other.getNshFlags())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNshFlagsImpl otherImpl = (NxmNxNshFlagsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNshFlags");
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "_nshFlags", _nshFlags);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
