package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * grouping range-grouping {
 *   leaf start {
 *     type uint16;
 *   }
 *   leaf end {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/range-grouping</i>
 *
 */
public interface RangeGrouping
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("range-grouping");

    @Override
    Class<? extends RangeGrouping> implementedInterface();
    
    /**
     * Include value.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>start</code>, or <code>null</code> if not present
     */
    Uint16 getStart();
    
    /**
     * Include value.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.common.Uint16</code> <code>end</code>, or <code>null</code> if not present
     */
    Uint16 getEnd();

}

