package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * grouping nx-action-conntrack-grouping {
 *   container nx-conntrack {
 *     leaf flags {
 *       type uint16;
 *     }
 *     leaf zone-src {
 *       type uint32;
 *     }
 *     leaf conntrack-zone {
 *       type uint16;
 *     }
 *     leaf recirc-table {
 *       type uint8;
 *     }
 *     list ct-actions {
 *       uses ofpact-actions;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping</i>
 *
 */
public interface NxActionConntrackGrouping
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-action-conntrack-grouping");

    @Override
    Class<? extends NxActionConntrackGrouping> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack</code> <code>nxConntrack</code>, or <code>null</code> if not present
     */
    NxConntrack getNxConntrack();

}

