package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.transmit.packet.input.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionConntrackRpcTransmitPacketCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionConntrackRpcTransmitPacketCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionConntrackRpcTransmitPacketCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionConntrackRpcTransmitPacketCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionConntrackRpcTransmitPacketCaseBuilder
 * @see Builder
 *
 */
public class NxActionConntrackRpcTransmitPacketCaseBuilder implements Builder<NxActionConntrackRpcTransmitPacketCase> {

    private NxConntrack _nxConntrack;


    Map<Class<? extends Augmentation<NxActionConntrackRpcTransmitPacketCase>>, Augmentation<NxActionConntrackRpcTransmitPacketCase>> augmentation = Collections.emptyMap();

    public NxActionConntrackRpcTransmitPacketCaseBuilder() {
    }
    public NxActionConntrackRpcTransmitPacketCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping arg) {
        this._nxConntrack = arg.getNxConntrack();
    }

    public NxActionConntrackRpcTransmitPacketCaseBuilder(NxActionConntrackRpcTransmitPacketCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionConntrackRpcTransmitPacketCase>>, Augmentation<NxActionConntrackRpcTransmitPacketCase>> aug =((AugmentationHolder<NxActionConntrackRpcTransmitPacketCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxConntrack = base.getNxConntrack();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping) {
            this._nxConntrack = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping)arg).getNxConntrack();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping]");
    }

    public NxConntrack getNxConntrack() {
        return _nxConntrack;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionConntrackRpcTransmitPacketCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionConntrackRpcTransmitPacketCaseBuilder setNxConntrack(final NxConntrack value) {
        this._nxConntrack = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionConntrackRpcTransmitPacketCaseBuilder addAugmentation(Augmentation<NxActionConntrackRpcTransmitPacketCase> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public NxActionConntrackRpcTransmitPacketCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionConntrackRpcTransmitPacketCase>> augmentationType, Augmentation<NxActionConntrackRpcTransmitPacketCase> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionConntrackRpcTransmitPacketCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionConntrackRpcTransmitPacketCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private NxActionConntrackRpcTransmitPacketCaseBuilder doAddAugmentation(Class<? extends Augmentation<NxActionConntrackRpcTransmitPacketCase>> augmentationType, Augmentation<NxActionConntrackRpcTransmitPacketCase> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public NxActionConntrackRpcTransmitPacketCase build() {
        return new NxActionConntrackRpcTransmitPacketCaseImpl(this);
    }

    private static final class NxActionConntrackRpcTransmitPacketCaseImpl
        extends AbstractAugmentable<NxActionConntrackRpcTransmitPacketCase>
        implements NxActionConntrackRpcTransmitPacketCase {
    
        private final NxConntrack _nxConntrack;
    
        NxActionConntrackRpcTransmitPacketCaseImpl(NxActionConntrackRpcTransmitPacketCaseBuilder base) {
            super(base.augmentation);
            this._nxConntrack = base.getNxConntrack();
        }
    
        @Override
        public NxConntrack getNxConntrack() {
            return _nxConntrack;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxConntrack);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionConntrackRpcTransmitPacketCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionConntrackRpcTransmitPacketCase other = (NxActionConntrackRpcTransmitPacketCase)obj;
            if (!Objects.equals(_nxConntrack, other.getNxConntrack())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionConntrackRpcTransmitPacketCaseImpl otherImpl = (NxActionConntrackRpcTransmitPacketCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionConntrackRpcTransmitPacketCase>>, Augmentation<NxActionConntrackRpcTransmitPacketCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionConntrackRpcTransmitPacketCase");
            CodeHelpers.appendValue(helper, "_nxConntrack", _nxConntrack);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
