package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * flow mod spec indicates the actions that should be performed to create a new 
 * flow which was learned from learn action.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * grouping flow-mod-spec {
 *   choice flow-mod-spec {
 *     case flow-mod-add-match-from-field-case {
 *       container flow-mod-add-match-from-field {
 *         leaf flow-mod-num-bits {
 *           type uint16;
 *         }
 *         leaf src-field {
 *           type uint32;
 *         }
 *         leaf src-ofs {
 *           type uint16;
 *         }
 *         leaf dst-field {
 *           type uint32;
 *         }
 *         leaf dst-ofs {
 *           type uint16;
 *         }
 *       }
 *     }
 *     case flow-mod-add-match-from-value-case {
 *       container flow-mod-add-match-from-value {
 *         leaf flow-mod-num-bits {
 *           type uint16;
 *         }
 *         leaf value {
 *           type uint16;
 *         }
 *         leaf src-field {
 *           type uint32;
 *         }
 *         leaf src-ofs {
 *           type uint16;
 *         }
 *       }
 *     }
 *     case flow-mod-copy-field-into-field-case {
 *       container flow-mod-copy-field-into-field {
 *         leaf flow-mod-num-bits {
 *           type uint16;
 *         }
 *         leaf src-field {
 *           type uint32;
 *         }
 *         leaf src-ofs {
 *           type uint16;
 *         }
 *         leaf dst-field {
 *           type uint32;
 *         }
 *         leaf dst-ofs {
 *           type uint16;
 *         }
 *       }
 *     }
 *     case flow-mod-copy-value-into-field-case {
 *       container flow-mod-copy-value-into-field {
 *         leaf flow-mod-num-bits {
 *           type uint16;
 *         }
 *         leaf value {
 *           type uint16;
 *         }
 *         leaf dst-field {
 *           type uint32;
 *         }
 *         leaf dst-ofs {
 *           type uint16;
 *         }
 *       }
 *     }
 *     case flow-mod-output-to-port-case {
 *       container flow-mod-output-to-port {
 *         leaf flow-mod-num-bits {
 *           type uint16;
 *         }
 *         leaf src-field {
 *           type uint32;
 *         }
 *         leaf src-ofs {
 *           type uint16;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/flow-mod-spec</i>
 *
 */
public interface FlowModSpec
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("flow-mod-spec");

    @Override
    Class<? extends FlowModSpec> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.FlowModSpec</code> <code>flowModSpec</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.@Nullable FlowModSpec getFlowModSpec();

}

