package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxIpv6SrcCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcNxIpv6SrcCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcNxIpv6SrcCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcNxIpv6SrcCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcNxIpv6SrcCaseBuilder
 * @see Builder
 *
 */
public class SrcNxIpv6SrcCaseBuilder implements Builder<SrcNxIpv6SrcCase> {

    private Empty _nxIpv6Src;


    Map<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> augmentation = Collections.emptyMap();

    public SrcNxIpv6SrcCaseBuilder() {
    }
    public SrcNxIpv6SrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping arg) {
        this._nxIpv6Src = arg.getNxIpv6Src();
    }

    public SrcNxIpv6SrcCaseBuilder(SrcNxIpv6SrcCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> aug =((AugmentationHolder<SrcNxIpv6SrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxIpv6Src = base.getNxIpv6Src();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping) {
            this._nxIpv6Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping)arg).getNxIpv6Src();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping]");
    }

    public Empty getNxIpv6Src() {
        return _nxIpv6Src;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxIpv6SrcCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxIpv6SrcCaseBuilder setNxIpv6Src(final Empty value) {
        this._nxIpv6Src = value;
        return this;
    }
    
    public SrcNxIpv6SrcCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxIpv6SrcCase>> augmentationType, Augmentation<SrcNxIpv6SrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxIpv6SrcCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxIpv6SrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxIpv6SrcCase build() {
        return new SrcNxIpv6SrcCaseImpl(this);
    }

    private static final class SrcNxIpv6SrcCaseImpl
        extends AbstractAugmentable<SrcNxIpv6SrcCase>
        implements SrcNxIpv6SrcCase {
    
        private final Empty _nxIpv6Src;
    
        SrcNxIpv6SrcCaseImpl(SrcNxIpv6SrcCaseBuilder base) {
            super(base.augmentation);
            this._nxIpv6Src = base.getNxIpv6Src();
        }
    
        @Override
        public Empty getNxIpv6Src() {
            return _nxIpv6Src;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxIpv6Src);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxIpv6SrcCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcNxIpv6SrcCase other = (SrcNxIpv6SrcCase)obj;
            if (!Objects.equals(_nxIpv6Src, other.getNxIpv6Src())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxIpv6SrcCaseImpl otherImpl = (SrcNxIpv6SrcCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxIpv6SrcCase");
            CodeHelpers.appendValue(helper, "_nxIpv6Src", _nxIpv6Src);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
