package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;openflowplugin-extension-nicira-match&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/openflowplugin-extension-nicira-match.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping all-matches-grouping {
 *     container nxm-of-arp-tpa {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-nx-nsi {
 *         leaf nsi {
 *             type uint8;
 *         }
 *     }
 *     container nxm-nx-nshc-2 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-of-eth-type {
 *         leaf value {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-arp-tha {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-of-tcp-dst {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-arp-sha {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-of-ip-dst {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-tcp-src {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-udp-dst {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-arp-spa {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-eth-dst {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-of-icmp-type {
 *         leaf value {
 *             type uint8;
 *         }
 *     }
 *     container nxm-nx-nshc-4 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-ct-zone {
 *         leaf ct-zone {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-tun-id {
 *         leaf value {
 *             type uint64;
 *         }
 *     }
 *     container nxm-nx-nsp {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-tun-ipv4-dst {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-udp-src {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-ct-state {
 *         leaf ct-state {
 *             type uint32;
 *         }
 *         leaf mask {
 *             type uint32;
 *         }
 *     }
 *     container nxm-of-eth-src {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-nx-tun-ipv4-src {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-nx-nshc-3 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-of-arp-op {
 *         leaf value {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-ip-src {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-nx-reg {
 *         leaf reg {
 *             type identityref;
 *         }
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-nshc-1 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;openflowplugin-extension-nicira-match/all-matches-grouping&lt;/i&gt;
 *
 */
public interface AllMatchesGrouping
    extends
    DataObject,
    NxmNxCtZoneGrouping,
    NxmOfEthDstGrouping,
    NxmOfIpSrcGrouping,
    NxmNxNshc2Grouping,
    NxmNxTunIpv4DstGrouping,
    NxmOfEthTypeGrouping,
    NxmNxArpThaGrouping,
    NxmNxRegGrouping,
    NxmNxNshc1Grouping,
    NxmOfIcmpTypeGrouping,
    NxmNxNshc4Grouping,
    NxmOfEthSrcGrouping,
    NxmNxTunIpv4SrcGrouping,
    NxmOfTcpSrcGrouping,
    NxmNxTunIdGrouping,
    NxmNxCtStateGrouping,
    NxmNxArpShaGrouping,
    NxmNxNsiGrouping,
    NxmOfArpOpGrouping,
    NxmOfIpDstGrouping,
    NxmOfArpTpaGrouping,
    NxmNxNshc3Grouping,
    NxmOfUdpSrcGrouping,
    NxmOfArpSpaGrouping,
    NxmOfUdpDstGrouping,
    NxmOfTcpDstGrouping,
    NxmNxNspGrouping
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:match","2014-07-14","all-matches-grouping"));


}

