package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;


/**
 * Choose the register with the OpenFlow output port, using the number of bits 
 * specified from the register.
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;openflowplugin-extension-nicira-action&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/openflowplugin-extension-nicira-action.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container src {
 *     choice src-choice {
 *         case src-nx-arp-sha-case {
 *             leaf nx-arp-sha {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-arp-tha-case {
 *             leaf nx-arp-tha {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-nshc-1-case {
 *             leaf nx-nshc-1-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-nshc-2-case {
 *             leaf nx-nshc-2-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-nshc-3-case {
 *             leaf nx-nshc-3-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-nshc-4-case {
 *             leaf nx-nshc-4-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-nsi-case {
 *             leaf nx-nsi-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-nsp-case {
 *             leaf nx-nsp-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-reg-case {
 *             leaf nx-reg {
 *                 type identityref;
 *             }
 *         }
 *         case src-nx-tun-id-case {
 *             leaf nx-tun-id {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-tun-ipv4-dst-case {
 *             leaf nx-tun-ipv4-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-nx-tun-ipv4-src-case {
 *             leaf nx-tun-ipv4-src {
 *                 type empty;
 *             }
 *         }
 *         case src-of-arp-op-case {
 *             leaf of-arp-op {
 *                 type empty;
 *             }
 *         }
 *         case src-of-arp-spa-case {
 *             leaf of-arp-spa {
 *                 type empty;
 *             }
 *         }
 *         case src-of-arp-tpa-case {
 *             leaf of-arp-tpa {
 *                 type empty;
 *             }
 *         }
 *         case src-of-eth-dst-case {
 *             leaf of-eth-dst {
 *                 type empty;
 *             }
 *         }
 *         case src-of-eth-src-case {
 *             leaf of-eth-src {
 *                 type empty;
 *             }
 *         }
 *         case src-of-eth-type-case {
 *             leaf of-eth-type {
 *                 type empty;
 *             }
 *         }
 *     }
 *     leaf ofs_nbits {
 *         type uint16;
 *     }
 *     uses src-choice-grouping;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;openflowplugin-extension-nicira-action/nx-action-output-reg-grouping/nx-output-reg/src&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.SrcBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.SrcBuilder
 *
 */
public interface Src
    extends
    ChildOf<NxOutputReg>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src>,
    SrcChoiceGrouping
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action","2014-07-14","src"));

    java.lang.Integer getOfsNbits();

}

