/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move.Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrcBuilder {
    private Integer _end;
    private static List<Range<BigInteger>> _end_range;
    private SrcChoice _srcChoice;
    private Integer _start;
    private static List<Range<BigInteger>> _start_range;
    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();

    public SrcBuilder() {
    }

    public SrcBuilder(RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public SrcBuilder(SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }

    public SrcBuilder(Src base) {
        this._end = base.getEnd();
        this._srcChoice = base.getSrcChoice();
        this._start = base.getStart();
        if (base instanceof SrcImpl) {
            SrcImpl _impl = (SrcImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RangeGrouping) {
            this._start = ((RangeGrouping)arg).getStart();
            this._end = ((RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        if (arg instanceof SrcChoiceGrouping) {
            this._srcChoice = ((SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping] \nbut was: " + arg);
        }
    }

    public Integer getEnd() {
        return this._end;
    }

    public SrcChoice getSrcChoice() {
        return this._srcChoice;
    }

    public Integer getStart() {
        return this._start;
    }

    public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SrcBuilder setEnd(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : SrcBuilder._end_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _end_range));
            }
        }
        this._end = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _end_range() {
        if (_end_range != null) return _end_range;
        Class<SrcBuilder> clazz = SrcBuilder.class;
        synchronized (SrcBuilder.class) {
            if (_end_range != null) return _end_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _end_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _end_range;
        }
    }

    public SrcBuilder setSrcChoice(SrcChoice value) {
        this._srcChoice = value;
        return this;
    }

    public SrcBuilder setStart(Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.intValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : SrcBuilder._start_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _start_range));
            }
        }
        this._start = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _start_range() {
        if (_start_range != null) return _start_range;
        Class<SrcBuilder> clazz = SrcBuilder.class;
        synchronized (SrcBuilder.class) {
            if (_start_range != null) return _start_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
            _start_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _start_range;
        }
    }

    public SrcBuilder addAugmentation(Class<? extends Augmentation<Src>> augmentationType, Augmentation<Src> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl
    implements Src {
        private final Integer _end;
        private final SrcChoice _srcChoice;
        private final Integer _start;
        private Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();

        public Class<Src> getImplementedInterface() {
            return Src.class;
        }

        private SrcImpl(SrcBuilder base) {
            this._end = base.getEnd();
            this._srcChoice = base.getSrcChoice();
            this._start = base.getStart();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getEnd() {
            return this._end;
        }

        @Override
        public SrcChoice getSrcChoice() {
            return this._srcChoice;
        }

        @Override
        public Integer getStart() {
            return this._start;
        }

        public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._end == null ? 0 : this._end.hashCode());
            result = 31 * result + (this._srcChoice == null ? 0 : this._srcChoice.hashCode());
            result = 31 * result + (this._start == null ? 0 : this._start.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Src other = (Src)obj;
            if (this._end == null ? other.getEnd() != null : !this._end.equals(other.getEnd())) {
                return false;
            }
            if (this._srcChoice == null ? other.getSrcChoice() != null : !this._srcChoice.equals(other.getSrcChoice())) {
                return false;
            }
            if (this._start == null ? other.getStart() != null : !this._start.equals(other.getStart())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrcImpl otherImpl = (SrcImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Src [");
            boolean first = true;
            if (this._end != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_end=");
                builder.append(this._end);
            }
            if (this._srcChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcChoice=");
                builder.append(this._srcChoice);
            }
            if (this._start != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_start=");
                builder.append(this._start);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

