/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match;

import com.google.common.base.Optional;
import java.math.BigInteger;
import org.opendaylight.openflowplugin.extension.api.ConvertorFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorToOFJava;
import org.opendaylight.openflowplugin.extension.api.ExtensionAugment;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.api.path.MatchPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match.MatchUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.grouping.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.OfjAugNxMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.OfjAugNxMatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.tun.id.grouping.TunIdValues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.tun.id.grouping.TunIdValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.ExtensionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.general.extension.grouping.Extension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketInBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifUpdateFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifUpdateFlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping.NxmNxTunId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping.NxmNxTunIdBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class TunIdConvertor
implements ConvertorToOFJava<MatchEntries>,
ConvertorFromOFJava<MatchEntries, MatchPath> {
    public ExtensionAugment<? extends Augmentation<Extension>> convert(MatchEntries input, MatchPath path) {
        TunIdValues values = ((OfjAugNxMatch)input.getAugmentation(OfjAugNxMatch.class)).getTunIdValues();
        return TunIdConvertor.resolveAugmentation(new NxmNxTunIdBuilder().setValue(values.getValue()).build(), path, NxmNxTunIdKey.class);
    }

    private static ExtensionAugment<? extends Augmentation<Extension>> resolveAugmentation(NxmNxTunId value, MatchPath path, Class<? extends ExtensionKey> key) {
        switch (path) {
            case FLOWSSTATISTICSUPDATE_FLOWANDSTATISTICSMAPLIST_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifUpdateFlowStats.class, (Augmentation)new NxAugMatchNotifUpdateFlowStatsBuilder().setNxmNxTunId(value).build(), key);
            }
            case PACKETRECEIVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifPacketIn.class, (Augmentation)new NxAugMatchNotifPacketInBuilder().setNxmNxTunId(value).build(), key);
            }
            case SWITCHFLOWREMOVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifSwitchFlowRemoved.class, (Augmentation)new NxAugMatchNotifSwitchFlowRemovedBuilder().setNxmNxTunId(value).build(), key);
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }

    public MatchEntries convert(Extension extension) {
        Optional matchGrouping = MatchUtil.tunIdResolver.getExtension((Augmentable)extension);
        if (!matchGrouping.isPresent()) {
            throw new CodecPreconditionException(extension);
        }
        BigInteger value = ((NxmNxTunIdGrouping)matchGrouping.get()).getNxmNxTunId().getValue();
        OfjAugNxMatchBuilder augNxMatchBuilder = new OfjAugNxMatchBuilder().setTunIdValues(new TunIdValuesBuilder().setValue(value).build());
        return MatchUtil.createNiciraMatchEntries(Nxm1Class.class, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxTunId.class, false, augNxMatchBuilder.build());
    }
}

