/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.udp.dst.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.udp.dst.grouping.UdpDstValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UdpDstValuesBuilder
implements Builder<UdpDstValues> {
    private Integer _mask;
    private PortNumber _port;
    Map<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>> augmentation = Collections.emptyMap();

    public UdpDstValuesBuilder() {
    }

    public UdpDstValuesBuilder(UdpDstValues base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        this._port = base.getPort();
        if (base instanceof UdpDstValuesImpl) {
            UdpDstValuesImpl impl = (UdpDstValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>>(casted.augmentations());
        }
    }

    public Integer getMask() {
        return this._mask;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<UdpDstValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaskRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public UdpDstValuesBuilder setMask(Integer value) {
        if (value != null) {
            UdpDstValuesBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public UdpDstValuesBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public UdpDstValuesBuilder addAugmentation(Class<? extends Augmentation<UdpDstValues>> augmentationType, Augmentation<UdpDstValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UdpDstValuesBuilder removeAugmentation(Class<? extends Augmentation<UdpDstValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UdpDstValues build() {
        return new UdpDstValuesImpl(this);
    }

    private static final class UdpDstValuesImpl
    implements UdpDstValues {
        private final Integer _mask;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UdpDstValues> getImplementedInterface() {
            return UdpDstValues.class;
        }

        private UdpDstValuesImpl(UdpDstValuesBuilder base) {
            this._mask = base.getMask();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMask() {
            return this._mask;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<UdpDstValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._port);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UdpDstValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UdpDstValues other = (UdpDstValues)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UdpDstValuesImpl otherImpl = (UdpDstValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UdpDstValues>>, Augmentation<UdpDstValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("UdpDstValues [");
            boolean first = true;
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(this._mask);
            }
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

