/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.arp.op.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.arp.op.grouping.ArpOpValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArpOpValuesBuilder
implements Builder<ArpOpValues> {
    private Integer _value;
    Map<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>> augmentation = Collections.emptyMap();

    public ArpOpValuesBuilder() {
    }

    public ArpOpValuesBuilder(ArpOpValues base) {
        AugmentationHolder casted;
        this._value = base.getValue();
        if (base instanceof ArpOpValuesImpl) {
            ArpOpValuesImpl impl = (ArpOpValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>>(casted.augmentations());
        }
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<ArpOpValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ArpOpValuesBuilder setValue(Integer value) {
        if (value != null) {
            ArpOpValuesBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public ArpOpValuesBuilder addAugmentation(Class<? extends Augmentation<ArpOpValues>> augmentationType, Augmentation<ArpOpValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArpOpValuesBuilder removeAugmentation(Class<? extends Augmentation<ArpOpValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ArpOpValues build() {
        return new ArpOpValuesImpl(this);
    }

    private static final class ArpOpValuesImpl
    implements ArpOpValues {
        private final Integer _value;
        private Map<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ArpOpValues> getImplementedInterface() {
            return ArpOpValues.class;
        }

        private ArpOpValuesImpl(ArpOpValuesBuilder base) {
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        public <E extends Augmentation<ArpOpValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ArpOpValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ArpOpValues other = (ArpOpValues)obj;
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ArpOpValuesImpl otherImpl = (ArpOpValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ArpOpValues>>, Augmentation<ArpOpValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ArpOpValues [");
            boolean first = true;
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

