/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nsp.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nsp.grouping.NxActionSetNsp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionSetNspBuilder
implements Builder<NxActionSetNsp> {
    private ExperimenterId _experimenterId;
    private Long _nsp;
    Map<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>> augmentation = Collections.emptyMap();

    public NxActionSetNspBuilder() {
    }

    public NxActionSetNspBuilder(NxActionSetNsp base) {
        AugmentationHolder casted;
        this._experimenterId = base.getExperimenterId();
        this._nsp = base.getNsp();
        if (base instanceof NxActionSetNspImpl) {
            NxActionSetNspImpl impl = (NxActionSetNspImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>>(casted.augmentations());
        }
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Long getNsp() {
        return this._nsp;
    }

    public <E extends Augmentation<NxActionSetNsp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxActionSetNspBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkNspRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionSetNspBuilder setNsp(Long value) {
        if (value != null) {
            NxActionSetNspBuilder.checkNspRange(value);
        }
        this._nsp = value;
        return this;
    }

    public NxActionSetNspBuilder addAugmentation(Class<? extends Augmentation<NxActionSetNsp>> augmentationType, Augmentation<NxActionSetNsp> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionSetNspBuilder removeAugmentation(Class<? extends Augmentation<NxActionSetNsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionSetNsp build() {
        return new NxActionSetNspImpl(this);
    }

    private static final class NxActionSetNspImpl
    implements NxActionSetNsp {
        private final ExperimenterId _experimenterId;
        private final Long _nsp;
        private Map<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionSetNsp> getImplementedInterface() {
            return NxActionSetNsp.class;
        }

        private NxActionSetNspImpl(NxActionSetNspBuilder base) {
            this._experimenterId = base.getExperimenterId();
            this._nsp = base.getNsp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>>(base.augmentation);
                }
            }
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Long getNsp() {
            return this._nsp;
        }

        public <E extends Augmentation<NxActionSetNsp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._nsp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionSetNsp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionSetNsp other = (NxActionSetNsp)obj;
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._nsp, other.getNsp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionSetNspImpl otherImpl = (NxActionSetNspImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionSetNsp>>, Augmentation<NxActionSetNsp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionSetNsp [");
            boolean first = true;
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._nsp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nsp=");
                builder.append(this._nsp);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

