/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.output.reg.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.output.reg.grouping.NxActionOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionOutputRegBuilder
implements Builder<NxActionOutputReg> {
    private ExperimenterId _experimenterId;
    private Integer _maxLen;
    private Integer _nBits;
    private Long _src;
    Map<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>> augmentation = Collections.emptyMap();

    public NxActionOutputRegBuilder() {
    }

    public NxActionOutputRegBuilder(NxActionOutputReg base) {
        AugmentationHolder casted;
        this._experimenterId = base.getExperimenterId();
        this._maxLen = base.getMaxLen();
        this._nBits = base.getNBits();
        this._src = base.getSrc();
        if (base instanceof NxActionOutputRegImpl) {
            NxActionOutputRegImpl impl = (NxActionOutputRegImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>>(casted.augmentations());
        }
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Integer getMaxLen() {
        return this._maxLen;
    }

    public Integer getNBits() {
        return this._nBits;
    }

    public Long getSrc() {
        return this._src;
    }

    public <E extends Augmentation<NxActionOutputReg>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxActionOutputRegBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkMaxLenRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionOutputRegBuilder setMaxLen(Integer value) {
        if (value != null) {
            NxActionOutputRegBuilder.checkMaxLenRange(value);
        }
        this._maxLen = value;
        return this;
    }

    private static void checkNBitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionOutputRegBuilder setNBits(Integer value) {
        if (value != null) {
            NxActionOutputRegBuilder.checkNBitsRange(value);
        }
        this._nBits = value;
        return this;
    }

    private static void checkSrcRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionOutputRegBuilder setSrc(Long value) {
        if (value != null) {
            NxActionOutputRegBuilder.checkSrcRange(value);
        }
        this._src = value;
        return this;
    }

    public NxActionOutputRegBuilder addAugmentation(Class<? extends Augmentation<NxActionOutputReg>> augmentationType, Augmentation<NxActionOutputReg> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionOutputRegBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputReg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionOutputReg build() {
        return new NxActionOutputRegImpl(this);
    }

    private static final class NxActionOutputRegImpl
    implements NxActionOutputReg {
        private final ExperimenterId _experimenterId;
        private final Integer _maxLen;
        private final Integer _nBits;
        private final Long _src;
        private Map<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionOutputReg> getImplementedInterface() {
            return NxActionOutputReg.class;
        }

        private NxActionOutputRegImpl(NxActionOutputRegBuilder base) {
            this._experimenterId = base.getExperimenterId();
            this._maxLen = base.getMaxLen();
            this._nBits = base.getNBits();
            this._src = base.getSrc();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>>(base.augmentation);
                }
            }
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Integer getMaxLen() {
            return this._maxLen;
        }

        @Override
        public Integer getNBits() {
            return this._nBits;
        }

        @Override
        public Long getSrc() {
            return this._src;
        }

        public <E extends Augmentation<NxActionOutputReg>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._maxLen);
            result = 31 * result + Objects.hashCode(this._nBits);
            result = 31 * result + Objects.hashCode(this._src);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionOutputReg.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionOutputReg other = (NxActionOutputReg)obj;
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._maxLen, other.getMaxLen())) {
                return false;
            }
            if (!Objects.equals(this._nBits, other.getNBits())) {
                return false;
            }
            if (!Objects.equals(this._src, other.getSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionOutputRegImpl otherImpl = (NxActionOutputRegImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionOutputReg>>, Augmentation<NxActionOutputReg>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionOutputReg [");
            boolean first = true;
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._maxLen != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLen=");
                builder.append(this._maxLen);
            }
            if (this._nBits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nBits=");
                builder.append(this._nBits);
            }
            if (this._src != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_src=");
                builder.append(this._src);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

