/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import com.google.common.primitives.Ints;

public class NxmHeader {
    private final long headerAsLong;
    private final int oxmClass;
    private final int nxmField;
    private final boolean hasMask;
    private final int length;

    public NxmHeader(long header) {
        this.headerAsLong = header;
        this.oxmClass = Ints.checkedCast((long)NxmHeader.extractSub(header, 16, 16));
        this.nxmField = Ints.checkedCast((long)NxmHeader.extractSub(header, 7, 9));
        this.hasMask = NxmHeader.extractSub(header, 1, 8) == 1L;
        this.length = Ints.checkedCast((long)NxmHeader.extractSub(header, 8, 0));
    }

    public NxmHeader(int oxmClass, int nxmField, boolean hasMask, int length) {
        this.oxmClass = oxmClass;
        this.nxmField = nxmField;
        this.hasMask = hasMask;
        this.length = length;
        this.headerAsLong = (long)oxmClass << 16 | (long)(nxmField << 9) | (long)((hasMask ? 1 : 0) << 8) | (long)length;
    }

    private static long extractSub(long l, int nrBits, int offset) {
        long rightShifted = l >>> offset;
        long mask = (1L << nrBits) - 1L;
        return rightShifted & mask;
    }

    public long toLong() {
        return this.headerAsLong;
    }

    public int getOxmClass() {
        return this.oxmClass;
    }

    public int getNxmField() {
        return this.nxmField;
    }

    public boolean isHasMask() {
        return this.hasMask;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.headerAsLong ^ this.headerAsLong >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NxmHeader other = (NxmHeader)obj;
        return this.headerAsLong == other.headerAsLong;
    }

    public String toString() {
        return "NxmHeader [headerAsLong=" + this.headerAsLong + ", oxmClass=" + this.oxmClass + ", nxmField=" + this.nxmField + ", hasMask=" + this.hasMask + ", length=" + this.length + "]";
    }
}

