/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmOfEthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.eth.src.grouping.EthSrcValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.EthSrcCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.EthSrcCaseValueBuilder;

public class EthSrcCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 6;
    private static final int NXM_FIELD_CODE = 2;
    public static final MatchEntrySerializerKey<Nxm0Class, NxmOfEthSrc> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm0Class.class, NxmOfEthSrc.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 0, 2);

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        EthSrcCaseValue ethSrcCase = (EthSrcCaseValue)input.getMatchEntryValue();
        outBuffer.writeBytes(ByteBufUtils.macAddressToBytes((String)ethSrcCase.getEthSrcValues().getMacAddress().getValue()));
    }

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntryBuilder = this.deserializeHeader(message);
        byte[] address = new byte[6];
        message.readBytes(address);
        EthSrcCaseValueBuilder caseBuilder = new EthSrcCaseValueBuilder();
        caseBuilder.setEthSrcValues(new EthSrcValuesBuilder().setMacAddress(new MacAddress(ByteBufUtils.macAddressToString((byte[])address))).build());
        matchEntryBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        matchEntryBuilder.setHasMask(Boolean.valueOf(false));
        return matchEntryBuilder.build();
    }

    @Override
    public int getNxmFieldCode() {
        return 2;
    }

    @Override
    public int getOxmClassCode() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return 6;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmOfEthSrc.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm0Class.class;
    }
}

