/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionResubmit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionResubmitBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.resubmit.grouping.NxActionResubmitBuilder;

public class ResubmitCodec
extends AbstractActionCodec {
    public static final int LENGTH = 16;
    public static final byte NXAST_RESUBMIT_SUBTYPE = 1;
    public static final byte NXAST_RESUBMIT_TABLE_SUBTYPE = 14;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionResubmit.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 1);
    public static final NiciraActionDeserializerKey TABLE_DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 14);
    private static final byte OFP_TABLE_ALL = -1;
    private static final short OFP_IN_PORT = -8;
    private static final int padding = 3;

    public byte getSubType(ActionResubmit action) {
        if (action.getNxActionResubmit().getTable() == null || action.getNxActionResubmit().getTable().byteValue() == -1) {
            return 1;
        }
        return 14;
    }

    public void serialize(Action input, ByteBuf outBuffer) {
        int table = -1;
        int inPort = -8;
        ActionResubmit action = (ActionResubmit)input.getActionChoice();
        ResubmitCodec.serializeHeader(16, this.getSubType(action), outBuffer);
        if (action.getNxActionResubmit().getInPort() != null) {
            inPort = action.getNxActionResubmit().getInPort().shortValue();
        }
        if (action.getNxActionResubmit().getTable() != null) {
            table = action.getNxActionResubmit().getTable().byteValue();
        }
        outBuffer.writeShort(inPort);
        outBuffer.writeByte(table);
        outBuffer.writeZero(3);
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = ResubmitCodec.deserializeHeader(message);
        ActionResubmitBuilder builder = new ActionResubmitBuilder();
        NxActionResubmitBuilder nxActionResubmitBuilder = new NxActionResubmitBuilder();
        nxActionResubmitBuilder.setInPort(message.readUnsignedShort());
        nxActionResubmitBuilder.setTable(message.readUnsignedByte());
        builder.setNxActionResubmit(nxActionResubmitBuilder.build());
        message.skipBytes(3);
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

