/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraConstants;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;

public abstract class AbstractActionCodec
implements OFSerializer<Action>,
OFDeserializer<Action> {
    protected static final void serializeHeader(int msgLength, int subtype, ByteBuf outBuffer) {
        outBuffer.writeShort(65535);
        AbstractActionCodec.writeMsgLengthVendorIdSubtypeToBuffer(msgLength, subtype, outBuffer);
    }

    private static final void writeMsgLengthVendorIdSubtypeToBuffer(int msgLength, int subtype, ByteBuf outBuffer) {
        outBuffer.writeShort(msgLength);
        outBuffer.writeInt(NiciraConstants.NX_VENDOR_ID.intValue());
        outBuffer.writeShort(subtype);
    }

    protected static final ActionBuilder deserializeHeader(ByteBuf message) {
        message.skipBytes(2);
        message.skipBytes(2);
        message.skipBytes(4);
        message.skipBytes(2);
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setExperimenterId(AbstractActionCodec.getExperimenterId());
        return actionBuilder;
    }

    protected static final ExperimenterId getExperimenterId() {
        return new ExperimenterId(NiciraConstants.NX_VENDOR_ID);
    }
}

