/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.TableUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.UpdateTableInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.table.update.OriginalTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.table.update.UpdatedTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateTableInputBuilder
implements Builder<UpdateTableInput> {
    private NodeRef _node;
    private OriginalTable _originalTable;
    private TableRef _tableRef;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private UpdatedTable _updatedTable;
    Map<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> augmentation = Collections.emptyMap();

    public UpdateTableInputBuilder() {
    }

    public UpdateTableInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateTableInputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public UpdateTableInputBuilder(TableUpdate arg) {
        this._originalTable = arg.getOriginalTable();
        this._updatedTable = arg.getUpdatedTable();
        this._node = arg.getNode();
    }

    public UpdateTableInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateTableInputBuilder(UpdateTableInput base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._originalTable = base.getOriginalTable();
        this._tableRef = base.getTableRef();
        this._transactionId = base.getTransactionId();
        this._transactionUri = base.getTransactionUri();
        this._updatedTable = base.getUpdatedTable();
        if (base instanceof UpdateTableInputImpl) {
            UpdateTableInputImpl impl = (UpdateTableInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TableUpdate) {
            this._originalTable = ((TableUpdate)arg).getOriginalTable();
            this._updatedTable = ((TableUpdate)arg).getUpdatedTable();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.TableUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalTable getOriginalTable() {
        return this._originalTable;
    }

    public TableRef getTableRef() {
        return this._tableRef;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public UpdatedTable getUpdatedTable() {
        return this._updatedTable;
    }

    public <E extends Augmentation<UpdateTableInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateTableInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateTableInputBuilder setOriginalTable(OriginalTable value) {
        this._originalTable = value;
        return this;
    }

    public UpdateTableInputBuilder setTableRef(TableRef value) {
        this._tableRef = value;
        return this;
    }

    public UpdateTableInputBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public UpdateTableInputBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public UpdateTableInputBuilder setUpdatedTable(UpdatedTable value) {
        this._updatedTable = value;
        return this;
    }

    public UpdateTableInputBuilder addAugmentation(Class<? extends Augmentation<UpdateTableInput>> augmentationType, Augmentation<UpdateTableInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateTableInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateTableInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateTableInput build() {
        return new UpdateTableInputImpl(this);
    }

    private static final class UpdateTableInputImpl
    implements UpdateTableInput {
        private final NodeRef _node;
        private final OriginalTable _originalTable;
        private final TableRef _tableRef;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private final UpdatedTable _updatedTable;
        private Map<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateTableInput> getImplementedInterface() {
            return UpdateTableInput.class;
        }

        private UpdateTableInputImpl(UpdateTableInputBuilder base) {
            this._node = base.getNode();
            this._originalTable = base.getOriginalTable();
            this._tableRef = base.getTableRef();
            this._transactionId = base.getTransactionId();
            this._transactionUri = base.getTransactionUri();
            this._updatedTable = base.getUpdatedTable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>>(base.augmentation);
                }
            }
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalTable getOriginalTable() {
            return this._originalTable;
        }

        @Override
        public TableRef getTableRef() {
            return this._tableRef;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public UpdatedTable getUpdatedTable() {
            return this._updatedTable;
        }

        public <E extends Augmentation<UpdateTableInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._originalTable);
            result = 31 * result + Objects.hashCode(this._tableRef);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode(this._updatedTable);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateTableInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateTableInput other = (UpdateTableInput)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._originalTable, other.getOriginalTable())) {
                return false;
            }
            if (!Objects.equals(this._tableRef, other.getTableRef())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals(this._updatedTable, other.getUpdatedTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateTableInputImpl otherImpl = (UpdateTableInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateTableInput>>, Augmentation<UpdateTableInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UpdateTableInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._originalTable != null) {
                builder.append("_originalTable=");
                builder.append(this._originalTable);
                builder.append(", ");
            }
            if (this._tableRef != null) {
                builder.append("_tableRef=");
                builder.append(this._tableRef);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._updatedTable != null) {
                builder.append("_updatedTable=");
                builder.append(this._updatedTable);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

