/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.MultipartTransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.service.rev131026.TableUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.table.features.TableFeatures;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableUpdatedBuilder
implements Builder<TableUpdated> {
    private NodeRef _node;
    private List<TableFeatures> _tableFeatures;
    private TransactionId _transactionId;
    private Boolean _moreReplies;
    Map<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>> augmentation = Collections.emptyMap();

    public TableUpdatedBuilder() {
    }

    public TableUpdatedBuilder(MultipartTransactionAware arg) {
        this._moreReplies = arg.isMoreReplies();
        this._transactionId = arg.getTransactionId();
    }

    public TableUpdatedBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public TableUpdatedBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures arg) {
        this._tableFeatures = arg.getTableFeatures();
    }

    public TableUpdatedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public TableUpdatedBuilder(TableUpdated base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._tableFeatures = base.getTableFeatures();
        this._transactionId = base.getTransactionId();
        this._moreReplies = base.isMoreReplies();
        if (base instanceof TableUpdatedImpl) {
            TableUpdatedImpl impl = (TableUpdatedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof MultipartTransactionAware) {
            this._moreReplies = ((MultipartTransactionAware)arg).isMoreReplies();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures) {
            this._tableFeatures = ((org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures)arg).getTableFeatures();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.MultipartTransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableFeatures] \nbut was: " + arg);
        }
    }

    public NodeRef getNode() {
        return this._node;
    }

    public List<TableFeatures> getTableFeatures() {
        return this._tableFeatures;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Boolean isMoreReplies() {
        return this._moreReplies;
    }

    public <E extends Augmentation<TableUpdated>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableUpdatedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public TableUpdatedBuilder setTableFeatures(List<TableFeatures> value) {
        this._tableFeatures = value;
        return this;
    }

    public TableUpdatedBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public TableUpdatedBuilder setMoreReplies(Boolean value) {
        this._moreReplies = value;
        return this;
    }

    public TableUpdatedBuilder addAugmentation(Class<? extends Augmentation<TableUpdated>> augmentationType, Augmentation<TableUpdated> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableUpdatedBuilder removeAugmentation(Class<? extends Augmentation<TableUpdated>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TableUpdated build() {
        return new TableUpdatedImpl(this);
    }

    private static final class TableUpdatedImpl
    implements TableUpdated {
        private final NodeRef _node;
        private final List<TableFeatures> _tableFeatures;
        private final TransactionId _transactionId;
        private final Boolean _moreReplies;
        private Map<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TableUpdated> getImplementedInterface() {
            return TableUpdated.class;
        }

        private TableUpdatedImpl(TableUpdatedBuilder base) {
            this._node = base.getNode();
            this._tableFeatures = base.getTableFeatures();
            this._transactionId = base.getTransactionId();
            this._moreReplies = base.isMoreReplies();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>>(base.augmentation);
                }
            }
        }

        public NodeRef getNode() {
            return this._node;
        }

        public List<TableFeatures> getTableFeatures() {
            return this._tableFeatures;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Boolean isMoreReplies() {
            return this._moreReplies;
        }

        public <E extends Augmentation<TableUpdated>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._tableFeatures);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode(this._moreReplies);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TableUpdated.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TableUpdated other = (TableUpdated)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._tableFeatures, other.getTableFeatures())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals(this._moreReplies, other.isMoreReplies())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableUpdatedImpl otherImpl = (TableUpdatedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TableUpdated>>, Augmentation<TableUpdated>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TableUpdated [";
            StringBuilder builder = new StringBuilder(name);
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._tableFeatures != null) {
                builder.append("_tableFeatures=");
                builder.append(this._tableFeatures);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._moreReplies != null) {
                builder.append("_moreReplies=");
                builder.append(this._moreReplies);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

