/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev150305.get.queue.output;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.CommonQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueuePacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev150305.get.queue.output.PacketQueues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketQueuesBuilder
implements Builder<PacketQueues> {
    private Long _port;
    private Integer _property;
    private QueueId _queueId;
    Map<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>> augmentation = Collections.emptyMap();

    public PacketQueuesBuilder() {
    }

    public PacketQueuesBuilder(QueuePacket arg) {
        this._queueId = arg.getQueueId();
        this._port = arg.getPort();
        this._property = arg.getProperty();
    }

    public PacketQueuesBuilder(CommonQueue arg) {
        this._property = arg.getProperty();
    }

    public PacketQueuesBuilder(PacketQueues base) {
        AugmentationHolder casted;
        this._port = base.getPort();
        this._property = base.getProperty();
        this._queueId = base.getQueueId();
        if (base instanceof PacketQueuesImpl) {
            PacketQueuesImpl impl = (PacketQueuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueuePacket) {
            this._queueId = ((QueuePacket)arg).getQueueId();
            this._port = ((QueuePacket)arg).getPort();
            isValidArg = true;
        }
        if (arg instanceof CommonQueue) {
            this._property = ((CommonQueue)arg).getProperty();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueuePacket, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.CommonQueue] \nbut was: " + arg);
        }
    }

    public Long getPort() {
        return this._port;
    }

    public Integer getProperty() {
        return this._property;
    }

    public QueueId getQueueId() {
        return this._queueId;
    }

    public <E extends Augmentation<PacketQueues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPortRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PacketQueuesBuilder setPort(Long value) {
        if (value != null) {
            PacketQueuesBuilder.checkPortRange(value);
        }
        this._port = value;
        return this;
    }

    private static void checkPropertyRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public PacketQueuesBuilder setProperty(Integer value) {
        if (value != null) {
            PacketQueuesBuilder.checkPropertyRange(value);
        }
        this._property = value;
        return this;
    }

    public PacketQueuesBuilder setQueueId(QueueId value) {
        this._queueId = value;
        return this;
    }

    public PacketQueuesBuilder addAugmentation(Class<? extends Augmentation<PacketQueues>> augmentationType, Augmentation<PacketQueues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketQueuesBuilder removeAugmentation(Class<? extends Augmentation<PacketQueues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketQueues build() {
        return new PacketQueuesImpl(this);
    }

    private static final class PacketQueuesImpl
    implements PacketQueues {
        private final Long _port;
        private final Integer _property;
        private final QueueId _queueId;
        private Map<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PacketQueues> getImplementedInterface() {
            return PacketQueues.class;
        }

        private PacketQueuesImpl(PacketQueuesBuilder base) {
            this._port = base.getPort();
            this._property = base.getProperty();
            this._queueId = base.getQueueId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>>(base.augmentation);
                }
            }
        }

        public Long getPort() {
            return this._port;
        }

        public Integer getProperty() {
            return this._property;
        }

        public QueueId getQueueId() {
            return this._queueId;
        }

        public <E extends Augmentation<PacketQueues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._property);
            result = 31 * result + Objects.hashCode(this._queueId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketQueues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketQueues other = (PacketQueues)obj;
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._property, other.getProperty())) {
                return false;
            }
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketQueuesImpl otherImpl = (PacketQueuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketQueues>>, Augmentation<PacketQueues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PacketQueues [";
            StringBuilder builder = new StringBuilder(name);
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
                builder.append(", ");
            }
            if (this._property != null) {
                builder.append("_property=");
                builder.append(this._property);
                builder.append(", ");
            }
            if (this._queueId != null) {
                builder.append("_queueId=");
                builder.append(this._queueId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

