/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev150305;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortNumberUni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.service.rev150305.GetQueueInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetQueueInputBuilder
implements Builder<GetQueueInput> {
    private NodeRef _node;
    private PortNumberUni _portNumber;
    Map<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>> augmentation = Collections.emptyMap();

    public GetQueueInputBuilder() {
    }

    public GetQueueInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public GetQueueInputBuilder(GetQueueInput base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._portNumber = base.getPortNumber();
        if (base instanceof GetQueueInputImpl) {
            GetQueueInputImpl impl = (GetQueueInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef] \nbut was: " + arg);
        }
    }

    public NodeRef getNode() {
        return this._node;
    }

    public PortNumberUni getPortNumber() {
        return this._portNumber;
    }

    public <E extends Augmentation<GetQueueInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetQueueInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public GetQueueInputBuilder setPortNumber(PortNumberUni value) {
        this._portNumber = value;
        return this;
    }

    public GetQueueInputBuilder addAugmentation(Class<? extends Augmentation<GetQueueInput>> augmentationType, Augmentation<GetQueueInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetQueueInputBuilder removeAugmentation(Class<? extends Augmentation<GetQueueInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetQueueInput build() {
        return new GetQueueInputImpl(this);
    }

    private static final class GetQueueInputImpl
    implements GetQueueInput {
        private final NodeRef _node;
        private final PortNumberUni _portNumber;
        private Map<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetQueueInput> getImplementedInterface() {
            return GetQueueInput.class;
        }

        private GetQueueInputImpl(GetQueueInputBuilder base) {
            this._node = base.getNode();
            this._portNumber = base.getPortNumber();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>>(base.augmentation);
                }
            }
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public PortNumberUni getPortNumber() {
            return this._portNumber;
        }

        public <E extends Augmentation<GetQueueInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._portNumber);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetQueueInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetQueueInput other = (GetQueueInput)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._portNumber, other.getPortNumber())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetQueueInputImpl otherImpl = (GetQueueInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetQueueInput>>, Augmentation<GetQueueInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetQueueInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._portNumber != null) {
                builder.append("_portNumber=");
                builder.append(this._portNumber);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

