/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.UpdatePortInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.port.update.OriginalPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.port.update.UpdatedPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdatePortInputBuilder
implements Builder<UpdatePortInput> {
    private NodeRef _node;
    private OriginalPort _originalPort;
    private TransactionId _transactionId;
    private UpdatedPort _updatedPort;
    Map<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> augmentation = Collections.emptyMap();

    public UpdatePortInputBuilder() {
    }

    public UpdatePortInputBuilder(PortUpdate arg) {
        this._originalPort = arg.getOriginalPort();
        this._updatedPort = arg.getUpdatedPort();
        this._node = arg.getNode();
    }

    public UpdatePortInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdatePortInputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public UpdatePortInputBuilder(UpdatePortInput base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._originalPort = base.getOriginalPort();
        this._transactionId = base.getTransactionId();
        this._updatedPort = base.getUpdatedPort();
        if (base instanceof UpdatePortInputImpl) {
            UpdatePortInputImpl impl = (UpdatePortInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof PortUpdate) {
            this._originalPort = ((PortUpdate)arg).getOriginalPort();
            this._updatedPort = ((PortUpdate)arg).getUpdatedPort();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortUpdate, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalPort getOriginalPort() {
        return this._originalPort;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public UpdatedPort getUpdatedPort() {
        return this._updatedPort;
    }

    public <E extends Augmentation<UpdatePortInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdatePortInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdatePortInputBuilder setOriginalPort(OriginalPort value) {
        this._originalPort = value;
        return this;
    }

    public UpdatePortInputBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public UpdatePortInputBuilder setUpdatedPort(UpdatedPort value) {
        this._updatedPort = value;
        return this;
    }

    public UpdatePortInputBuilder addAugmentation(Class<? extends Augmentation<UpdatePortInput>> augmentationType, Augmentation<UpdatePortInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdatePortInputBuilder removeAugmentation(Class<? extends Augmentation<UpdatePortInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdatePortInput build() {
        return new UpdatePortInputImpl(this);
    }

    private static final class UpdatePortInputImpl
    implements UpdatePortInput {
        private final NodeRef _node;
        private final OriginalPort _originalPort;
        private final TransactionId _transactionId;
        private final UpdatedPort _updatedPort;
        private Map<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdatePortInput> getImplementedInterface() {
            return UpdatePortInput.class;
        }

        private UpdatePortInputImpl(UpdatePortInputBuilder base) {
            this._node = base.getNode();
            this._originalPort = base.getOriginalPort();
            this._transactionId = base.getTransactionId();
            this._updatedPort = base.getUpdatedPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>>(base.augmentation);
                }
            }
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalPort getOriginalPort() {
            return this._originalPort;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public UpdatedPort getUpdatedPort() {
            return this._updatedPort;
        }

        public <E extends Augmentation<UpdatePortInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._originalPort);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode(this._updatedPort);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdatePortInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdatePortInput other = (UpdatePortInput)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._originalPort, other.getOriginalPort())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals(this._updatedPort, other.getUpdatedPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdatePortInputImpl otherImpl = (UpdatePortInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdatePortInput>>, Augmentation<UpdatePortInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UpdatePortInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._originalPort != null) {
                builder.append("_originalPort=");
                builder.append(this._originalPort);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._updatedPort != null) {
                builder.append("_updatedPort=");
                builder.append(this._updatedPort);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

