/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowPortStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortNumberUni;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.service.rev131107.PortRemoved;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortRemovedBuilder
implements Builder<PortRemoved> {
    private PortFeatures _advertisedFeatures;
    private PortConfig _configuration;
    private PortFeatures _currentFeature;
    private Long _currentSpeed;
    private MacAddress _hardwareAddress;
    private Long _maximumSpeed;
    private String _name;
    private NodeRef _node;
    private PortFeatures _peerFeatures;
    private PortNumberUni _portNumber;
    private List<Queue> _queue;
    private PortReason _reason;
    private State _state;
    private PortFeatures _supported;
    Map<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> augmentation = Collections.emptyMap();

    public PortRemovedBuilder() {
    }

    public PortRemovedBuilder(FlowPortStatus arg) {
        this._reason = arg.getReason();
        this._name = arg.getName();
        this._state = arg.getState();
        this._currentFeature = arg.getCurrentFeature();
        this._supported = arg.getSupported();
        this._peerFeatures = arg.getPeerFeatures();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._queue = arg.getQueue();
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
    }

    public PortRemovedBuilder(FlowCapablePort arg) {
        this._name = arg.getName();
        this._state = arg.getState();
        this._currentFeature = arg.getCurrentFeature();
        this._supported = arg.getSupported();
        this._peerFeatures = arg.getPeerFeatures();
        this._currentSpeed = arg.getCurrentSpeed();
        this._maximumSpeed = arg.getMaximumSpeed();
        this._queue = arg.getQueue();
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
    }

    public PortRemovedBuilder(Queues arg) {
        this._queue = arg.getQueue();
    }

    public PortRemovedBuilder(CommonPort arg) {
        this._portNumber = arg.getPortNumber();
        this._hardwareAddress = arg.getHardwareAddress();
        this._configuration = arg.getConfiguration();
        this._advertisedFeatures = arg.getAdvertisedFeatures();
    }

    public PortRemovedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public PortRemovedBuilder(PortRemoved base) {
        AugmentationHolder casted;
        this._advertisedFeatures = base.getAdvertisedFeatures();
        this._configuration = base.getConfiguration();
        this._currentFeature = base.getCurrentFeature();
        this._currentSpeed = base.getCurrentSpeed();
        this._hardwareAddress = base.getHardwareAddress();
        this._maximumSpeed = base.getMaximumSpeed();
        this._name = base.getName();
        this._node = base.getNode();
        this._peerFeatures = base.getPeerFeatures();
        this._portNumber = base.getPortNumber();
        this._queue = base.getQueue();
        this._reason = base.getReason();
        this._state = base.getState();
        this._supported = base.getSupported();
        if (base instanceof PortRemovedImpl) {
            PortRemovedImpl impl = (PortRemovedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonPort) {
            this._portNumber = ((CommonPort)arg).getPortNumber();
            this._hardwareAddress = ((CommonPort)arg).getHardwareAddress();
            this._configuration = ((CommonPort)arg).getConfiguration();
            this._advertisedFeatures = ((CommonPort)arg).getAdvertisedFeatures();
            isValidArg = true;
        }
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof FlowCapablePort) {
            this._name = ((FlowCapablePort)arg).getName();
            this._state = ((FlowCapablePort)arg).getState();
            this._currentFeature = ((FlowCapablePort)arg).getCurrentFeature();
            this._supported = ((FlowCapablePort)arg).getSupported();
            this._peerFeatures = ((FlowCapablePort)arg).getPeerFeatures();
            this._currentSpeed = ((FlowCapablePort)arg).getCurrentSpeed();
            this._maximumSpeed = ((FlowCapablePort)arg).getMaximumSpeed();
            isValidArg = true;
        }
        if (arg instanceof Queues) {
            this._queue = ((Queues)arg).getQueue();
            isValidArg = true;
        }
        if (arg instanceof FlowPortStatus) {
            this._reason = ((FlowPortStatus)arg).getReason();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort, org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowCapablePort, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.Queues, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.FlowPortStatus] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortConfig getConfiguration() {
        return this._configuration;
    }

    public PortFeatures getCurrentFeature() {
        return this._currentFeature;
    }

    public Long getCurrentSpeed() {
        return this._currentSpeed;
    }

    public MacAddress getHardwareAddress() {
        return this._hardwareAddress;
    }

    public Long getMaximumSpeed() {
        return this._maximumSpeed;
    }

    public String getName() {
        return this._name;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public PortFeatures getPeerFeatures() {
        return this._peerFeatures;
    }

    public PortNumberUni getPortNumber() {
        return this._portNumber;
    }

    public List<Queue> getQueue() {
        return this._queue;
    }

    public PortReason getReason() {
        return this._reason;
    }

    public State getState() {
        return this._state;
    }

    public PortFeatures getSupported() {
        return this._supported;
    }

    public <E extends Augmentation<PortRemoved>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortRemovedBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public PortRemovedBuilder setConfiguration(PortConfig value) {
        this._configuration = value;
        return this;
    }

    public PortRemovedBuilder setCurrentFeature(PortFeatures value) {
        this._currentFeature = value;
        return this;
    }

    private static void checkCurrentSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortRemovedBuilder setCurrentSpeed(Long value) {
        if (value != null) {
            PortRemovedBuilder.checkCurrentSpeedRange(value);
        }
        this._currentSpeed = value;
        return this;
    }

    public PortRemovedBuilder setHardwareAddress(MacAddress value) {
        this._hardwareAddress = value;
        return this;
    }

    private static void checkMaximumSpeedRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public PortRemovedBuilder setMaximumSpeed(Long value) {
        if (value != null) {
            PortRemovedBuilder.checkMaximumSpeedRange(value);
        }
        this._maximumSpeed = value;
        return this;
    }

    public PortRemovedBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PortRemovedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public PortRemovedBuilder setPeerFeatures(PortFeatures value) {
        this._peerFeatures = value;
        return this;
    }

    public PortRemovedBuilder setPortNumber(PortNumberUni value) {
        this._portNumber = value;
        return this;
    }

    public PortRemovedBuilder setQueue(List<Queue> value) {
        this._queue = value;
        return this;
    }

    public PortRemovedBuilder setReason(PortReason value) {
        this._reason = value;
        return this;
    }

    public PortRemovedBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public PortRemovedBuilder setSupported(PortFeatures value) {
        this._supported = value;
        return this;
    }

    public PortRemovedBuilder addAugmentation(Class<? extends Augmentation<PortRemoved>> augmentationType, Augmentation<PortRemoved> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortRemovedBuilder removeAugmentation(Class<? extends Augmentation<PortRemoved>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PortRemoved build() {
        return new PortRemovedImpl(this);
    }

    private static final class PortRemovedImpl
    implements PortRemoved {
        private final PortFeatures _advertisedFeatures;
        private final PortConfig _configuration;
        private final PortFeatures _currentFeature;
        private final Long _currentSpeed;
        private final MacAddress _hardwareAddress;
        private final Long _maximumSpeed;
        private final String _name;
        private final NodeRef _node;
        private final PortFeatures _peerFeatures;
        private final PortNumberUni _portNumber;
        private final List<Queue> _queue;
        private final PortReason _reason;
        private final State _state;
        private final PortFeatures _supported;
        private Map<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PortRemoved> getImplementedInterface() {
            return PortRemoved.class;
        }

        private PortRemovedImpl(PortRemovedBuilder base) {
            this._advertisedFeatures = base.getAdvertisedFeatures();
            this._configuration = base.getConfiguration();
            this._currentFeature = base.getCurrentFeature();
            this._currentSpeed = base.getCurrentSpeed();
            this._hardwareAddress = base.getHardwareAddress();
            this._maximumSpeed = base.getMaximumSpeed();
            this._name = base.getName();
            this._node = base.getNode();
            this._peerFeatures = base.getPeerFeatures();
            this._portNumber = base.getPortNumber();
            this._queue = base.getQueue();
            this._reason = base.getReason();
            this._state = base.getState();
            this._supported = base.getSupported();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>>(base.augmentation);
                }
            }
        }

        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        public PortConfig getConfiguration() {
            return this._configuration;
        }

        public PortFeatures getCurrentFeature() {
            return this._currentFeature;
        }

        public Long getCurrentSpeed() {
            return this._currentSpeed;
        }

        public MacAddress getHardwareAddress() {
            return this._hardwareAddress;
        }

        public Long getMaximumSpeed() {
            return this._maximumSpeed;
        }

        public String getName() {
            return this._name;
        }

        public NodeRef getNode() {
            return this._node;
        }

        public PortFeatures getPeerFeatures() {
            return this._peerFeatures;
        }

        public PortNumberUni getPortNumber() {
            return this._portNumber;
        }

        public List<Queue> getQueue() {
            return this._queue;
        }

        public PortReason getReason() {
            return this._reason;
        }

        public State getState() {
            return this._state;
        }

        public PortFeatures getSupported() {
            return this._supported;
        }

        public <E extends Augmentation<PortRemoved>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._advertisedFeatures);
            result = 31 * result + Objects.hashCode(this._configuration);
            result = 31 * result + Objects.hashCode(this._currentFeature);
            result = 31 * result + Objects.hashCode(this._currentSpeed);
            result = 31 * result + Objects.hashCode(this._hardwareAddress);
            result = 31 * result + Objects.hashCode(this._maximumSpeed);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._peerFeatures);
            result = 31 * result + Objects.hashCode(this._portNumber);
            result = 31 * result + Objects.hashCode(this._queue);
            result = 31 * result + Objects.hashCode(this._reason);
            result = 31 * result + Objects.hashCode(this._state);
            result = 31 * result + Objects.hashCode(this._supported);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PortRemoved.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PortRemoved other = (PortRemoved)obj;
            if (!Objects.equals(this._advertisedFeatures, other.getAdvertisedFeatures())) {
                return false;
            }
            if (!Objects.equals(this._configuration, other.getConfiguration())) {
                return false;
            }
            if (!Objects.equals(this._currentFeature, other.getCurrentFeature())) {
                return false;
            }
            if (!Objects.equals(this._currentSpeed, other.getCurrentSpeed())) {
                return false;
            }
            if (!Objects.equals(this._hardwareAddress, other.getHardwareAddress())) {
                return false;
            }
            if (!Objects.equals(this._maximumSpeed, other.getMaximumSpeed())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._peerFeatures, other.getPeerFeatures())) {
                return false;
            }
            if (!Objects.equals(this._portNumber, other.getPortNumber())) {
                return false;
            }
            if (!Objects.equals(this._queue, other.getQueue())) {
                return false;
            }
            if (!Objects.equals(this._reason, other.getReason())) {
                return false;
            }
            if (!Objects.equals(this._state, other.getState())) {
                return false;
            }
            if (!Objects.equals(this._supported, other.getSupported())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PortRemovedImpl otherImpl = (PortRemovedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PortRemoved>>, Augmentation<PortRemoved>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PortRemoved [";
            StringBuilder builder = new StringBuilder(name);
            if (this._advertisedFeatures != null) {
                builder.append("_advertisedFeatures=");
                builder.append(this._advertisedFeatures);
                builder.append(", ");
            }
            if (this._configuration != null) {
                builder.append("_configuration=");
                builder.append(this._configuration);
                builder.append(", ");
            }
            if (this._currentFeature != null) {
                builder.append("_currentFeature=");
                builder.append(this._currentFeature);
                builder.append(", ");
            }
            if (this._currentSpeed != null) {
                builder.append("_currentSpeed=");
                builder.append(this._currentSpeed);
                builder.append(", ");
            }
            if (this._hardwareAddress != null) {
                builder.append("_hardwareAddress=");
                builder.append(this._hardwareAddress);
                builder.append(", ");
            }
            if (this._maximumSpeed != null) {
                builder.append("_maximumSpeed=");
                builder.append(this._maximumSpeed);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._peerFeatures != null) {
                builder.append("_peerFeatures=");
                builder.append(this._peerFeatures);
                builder.append(", ");
            }
            if (this._portNumber != null) {
                builder.append("_portNumber=");
                builder.append(this._portNumber);
                builder.append(", ");
            }
            if (this._queue != null) {
                builder.append("_queue=");
                builder.append(this._queue);
                builder.append(", ");
            }
            if (this._reason != null) {
                builder.append("_reason=");
                builder.append(this._reason);
                builder.append(", ");
            }
            if (this._state != null) {
                builder.append("_state=");
                builder.append(this._state);
                builder.append(", ");
            }
            if (this._supported != null) {
                builder.append("_supported=");
                builder.append(this._supported);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

