/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.ProtocolMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.TcpFlagsMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Tunnel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received.Match;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchBuilder
implements Builder<Match> {
    private EthernetMatch _ethernetMatch;
    private Icmpv4Match _icmpv4Match;
    private Icmpv6Match _icmpv6Match;
    private NodeConnectorId _inPhyPort;
    private NodeConnectorId _inPort;
    private IpMatch _ipMatch;
    private Layer3Match _layer3Match;
    private Layer4Match _layer4Match;
    private Metadata _metadata;
    private ProtocolMatchFields _protocolMatchFields;
    private TcpFlagsMatch _tcpFlagsMatch;
    private Tunnel _tunnel;
    private VlanMatch _vlanMatch;
    Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();

    public MatchBuilder() {
    }

    public MatchBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match arg) {
        this._inPort = arg.getInPort();
        this._inPhyPort = arg.getInPhyPort();
        this._metadata = arg.getMetadata();
        this._tunnel = arg.getTunnel();
        this._ethernetMatch = arg.getEthernetMatch();
        this._vlanMatch = arg.getVlanMatch();
        this._ipMatch = arg.getIpMatch();
        this._layer3Match = arg.getLayer3Match();
        this._layer4Match = arg.getLayer4Match();
        this._icmpv4Match = arg.getIcmpv4Match();
        this._icmpv6Match = arg.getIcmpv6Match();
        this._protocolMatchFields = arg.getProtocolMatchFields();
        this._tcpFlagsMatch = arg.getTcpFlagsMatch();
    }

    public MatchBuilder(Match base) {
        AugmentationHolder casted;
        this._ethernetMatch = base.getEthernetMatch();
        this._icmpv4Match = base.getIcmpv4Match();
        this._icmpv6Match = base.getIcmpv6Match();
        this._inPhyPort = base.getInPhyPort();
        this._inPort = base.getInPort();
        this._ipMatch = base.getIpMatch();
        this._layer3Match = base.getLayer3Match();
        this._layer4Match = base.getLayer4Match();
        this._metadata = base.getMetadata();
        this._protocolMatchFields = base.getProtocolMatchFields();
        this._tcpFlagsMatch = base.getTcpFlagsMatch();
        this._tunnel = base.getTunnel();
        this._vlanMatch = base.getVlanMatch();
        if (base instanceof MatchImpl) {
            MatchImpl impl = (MatchImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match) {
            this._inPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getInPort();
            this._inPhyPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getInPhyPort();
            this._metadata = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getMetadata();
            this._tunnel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getTunnel();
            this._ethernetMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getEthernetMatch();
            this._vlanMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getVlanMatch();
            this._ipMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIpMatch();
            this._layer3Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getLayer3Match();
            this._layer4Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getLayer4Match();
            this._icmpv4Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIcmpv4Match();
            this._icmpv6Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIcmpv6Match();
            this._protocolMatchFields = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getProtocolMatchFields();
            this._tcpFlagsMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getTcpFlagsMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match] \nbut was: " + arg);
        }
    }

    public EthernetMatch getEthernetMatch() {
        return this._ethernetMatch;
    }

    public Icmpv4Match getIcmpv4Match() {
        return this._icmpv4Match;
    }

    public Icmpv6Match getIcmpv6Match() {
        return this._icmpv6Match;
    }

    public NodeConnectorId getInPhyPort() {
        return this._inPhyPort;
    }

    public NodeConnectorId getInPort() {
        return this._inPort;
    }

    public IpMatch getIpMatch() {
        return this._ipMatch;
    }

    public Layer3Match getLayer3Match() {
        return this._layer3Match;
    }

    public Layer4Match getLayer4Match() {
        return this._layer4Match;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public ProtocolMatchFields getProtocolMatchFields() {
        return this._protocolMatchFields;
    }

    public TcpFlagsMatch getTcpFlagsMatch() {
        return this._tcpFlagsMatch;
    }

    public Tunnel getTunnel() {
        return this._tunnel;
    }

    public VlanMatch getVlanMatch() {
        return this._vlanMatch;
    }

    public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchBuilder setEthernetMatch(EthernetMatch value) {
        this._ethernetMatch = value;
        return this;
    }

    public MatchBuilder setIcmpv4Match(Icmpv4Match value) {
        this._icmpv4Match = value;
        return this;
    }

    public MatchBuilder setIcmpv6Match(Icmpv6Match value) {
        this._icmpv6Match = value;
        return this;
    }

    public MatchBuilder setInPhyPort(NodeConnectorId value) {
        this._inPhyPort = value;
        return this;
    }

    public MatchBuilder setInPort(NodeConnectorId value) {
        this._inPort = value;
        return this;
    }

    public MatchBuilder setIpMatch(IpMatch value) {
        this._ipMatch = value;
        return this;
    }

    public MatchBuilder setLayer3Match(Layer3Match value) {
        this._layer3Match = value;
        return this;
    }

    public MatchBuilder setLayer4Match(Layer4Match value) {
        this._layer4Match = value;
        return this;
    }

    public MatchBuilder setMetadata(Metadata value) {
        this._metadata = value;
        return this;
    }

    public MatchBuilder setProtocolMatchFields(ProtocolMatchFields value) {
        this._protocolMatchFields = value;
        return this;
    }

    public MatchBuilder setTcpFlagsMatch(TcpFlagsMatch value) {
        this._tcpFlagsMatch = value;
        return this;
    }

    public MatchBuilder setTunnel(Tunnel value) {
        this._tunnel = value;
        return this;
    }

    public MatchBuilder setVlanMatch(VlanMatch value) {
        this._vlanMatch = value;
        return this;
    }

    public MatchBuilder addAugmentation(Class<? extends Augmentation<Match>> augmentationType, Augmentation<Match> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchBuilder removeAugmentation(Class<? extends Augmentation<Match>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Match build() {
        return new MatchImpl(this);
    }

    private static final class MatchImpl
    implements Match {
        private final EthernetMatch _ethernetMatch;
        private final Icmpv4Match _icmpv4Match;
        private final Icmpv6Match _icmpv6Match;
        private final NodeConnectorId _inPhyPort;
        private final NodeConnectorId _inPort;
        private final IpMatch _ipMatch;
        private final Layer3Match _layer3Match;
        private final Layer4Match _layer4Match;
        private final Metadata _metadata;
        private final ProtocolMatchFields _protocolMatchFields;
        private final TcpFlagsMatch _tcpFlagsMatch;
        private final Tunnel _tunnel;
        private final VlanMatch _vlanMatch;
        private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Match> getImplementedInterface() {
            return Match.class;
        }

        private MatchImpl(MatchBuilder base) {
            this._ethernetMatch = base.getEthernetMatch();
            this._icmpv4Match = base.getIcmpv4Match();
            this._icmpv6Match = base.getIcmpv6Match();
            this._inPhyPort = base.getInPhyPort();
            this._inPort = base.getInPort();
            this._ipMatch = base.getIpMatch();
            this._layer3Match = base.getLayer3Match();
            this._layer4Match = base.getLayer4Match();
            this._metadata = base.getMetadata();
            this._protocolMatchFields = base.getProtocolMatchFields();
            this._tcpFlagsMatch = base.getTcpFlagsMatch();
            this._tunnel = base.getTunnel();
            this._vlanMatch = base.getVlanMatch();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Match>>, Augmentation<Match>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>(base.augmentation);
                }
            }
        }

        public EthernetMatch getEthernetMatch() {
            return this._ethernetMatch;
        }

        public Icmpv4Match getIcmpv4Match() {
            return this._icmpv4Match;
        }

        public Icmpv6Match getIcmpv6Match() {
            return this._icmpv6Match;
        }

        public NodeConnectorId getInPhyPort() {
            return this._inPhyPort;
        }

        public NodeConnectorId getInPort() {
            return this._inPort;
        }

        public IpMatch getIpMatch() {
            return this._ipMatch;
        }

        public Layer3Match getLayer3Match() {
            return this._layer3Match;
        }

        public Layer4Match getLayer4Match() {
            return this._layer4Match;
        }

        public Metadata getMetadata() {
            return this._metadata;
        }

        public ProtocolMatchFields getProtocolMatchFields() {
            return this._protocolMatchFields;
        }

        public TcpFlagsMatch getTcpFlagsMatch() {
            return this._tcpFlagsMatch;
        }

        public Tunnel getTunnel() {
            return this._tunnel;
        }

        public VlanMatch getVlanMatch() {
            return this._vlanMatch;
        }

        public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ethernetMatch);
            result = 31 * result + Objects.hashCode(this._icmpv4Match);
            result = 31 * result + Objects.hashCode(this._icmpv6Match);
            result = 31 * result + Objects.hashCode(this._inPhyPort);
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._ipMatch);
            result = 31 * result + Objects.hashCode(this._layer3Match);
            result = 31 * result + Objects.hashCode(this._layer4Match);
            result = 31 * result + Objects.hashCode(this._metadata);
            result = 31 * result + Objects.hashCode(this._protocolMatchFields);
            result = 31 * result + Objects.hashCode(this._tcpFlagsMatch);
            result = 31 * result + Objects.hashCode(this._tunnel);
            result = 31 * result + Objects.hashCode(this._vlanMatch);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Match.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Match other = (Match)obj;
            if (!Objects.equals(this._ethernetMatch, other.getEthernetMatch())) {
                return false;
            }
            if (!Objects.equals(this._icmpv4Match, other.getIcmpv4Match())) {
                return false;
            }
            if (!Objects.equals(this._icmpv6Match, other.getIcmpv6Match())) {
                return false;
            }
            if (!Objects.equals(this._inPhyPort, other.getInPhyPort())) {
                return false;
            }
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._ipMatch, other.getIpMatch())) {
                return false;
            }
            if (!Objects.equals(this._layer3Match, other.getLayer3Match())) {
                return false;
            }
            if (!Objects.equals(this._layer4Match, other.getLayer4Match())) {
                return false;
            }
            if (!Objects.equals(this._metadata, other.getMetadata())) {
                return false;
            }
            if (!Objects.equals(this._protocolMatchFields, other.getProtocolMatchFields())) {
                return false;
            }
            if (!Objects.equals(this._tcpFlagsMatch, other.getTcpFlagsMatch())) {
                return false;
            }
            if (!Objects.equals(this._tunnel, other.getTunnel())) {
                return false;
            }
            if (!Objects.equals(this._vlanMatch, other.getVlanMatch())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MatchImpl otherImpl = (MatchImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Match>>, Augmentation<Match>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Match [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ethernetMatch != null) {
                builder.append("_ethernetMatch=");
                builder.append(this._ethernetMatch);
                builder.append(", ");
            }
            if (this._icmpv4Match != null) {
                builder.append("_icmpv4Match=");
                builder.append(this._icmpv4Match);
                builder.append(", ");
            }
            if (this._icmpv6Match != null) {
                builder.append("_icmpv6Match=");
                builder.append(this._icmpv6Match);
                builder.append(", ");
            }
            if (this._inPhyPort != null) {
                builder.append("_inPhyPort=");
                builder.append(this._inPhyPort);
                builder.append(", ");
            }
            if (this._inPort != null) {
                builder.append("_inPort=");
                builder.append(this._inPort);
                builder.append(", ");
            }
            if (this._ipMatch != null) {
                builder.append("_ipMatch=");
                builder.append(this._ipMatch);
                builder.append(", ");
            }
            if (this._layer3Match != null) {
                builder.append("_layer3Match=");
                builder.append(this._layer3Match);
                builder.append(", ");
            }
            if (this._layer4Match != null) {
                builder.append("_layer4Match=");
                builder.append(this._layer4Match);
                builder.append(", ");
            }
            if (this._metadata != null) {
                builder.append("_metadata=");
                builder.append(this._metadata);
                builder.append(", ");
            }
            if (this._protocolMatchFields != null) {
                builder.append("_protocolMatchFields=");
                builder.append(this._protocolMatchFields);
                builder.append(", ");
            }
            if (this._tcpFlagsMatch != null) {
                builder.append("_tcpFlagsMatch=");
                builder.append(this._tcpFlagsMatch);
                builder.append(", ");
            }
            if (this._tunnel != null) {
                builder.append("_tunnel=");
                builder.append(this._tunnel);
                builder.append(", ");
            }
            if (this._vlanMatch != null) {
                builder.append("_vlanMatch=");
                builder.append(this._vlanMatch);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

