/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.ActionList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.ConnectionCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.TransmitPacketInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TransmitPacketInputBuilder
implements Builder<TransmitPacketInput> {
    private List<Action> _action;
    private Long _bufferId;
    private ConnectionCookie _connectionCookie;
    private NodeConnectorRef _egress;
    private NodeConnectorRef _ingress;
    private NodeRef _node;
    private byte[] _payload;
    Map<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> augmentation = Collections.emptyMap();

    public TransmitPacketInputBuilder() {
    }

    public TransmitPacketInputBuilder(RawPacket arg) {
        this._ingress = arg.getIngress();
        this._payload = arg.getPayload();
    }

    public TransmitPacketInputBuilder(ActionList arg) {
        this._action = arg.getAction();
    }

    public TransmitPacketInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public TransmitPacketInputBuilder(TransmitPacketInput base) {
        AugmentationHolder casted;
        this._action = base.getAction();
        this._bufferId = base.getBufferId();
        this._connectionCookie = base.getConnectionCookie();
        this._egress = base.getEgress();
        this._ingress = base.getIngress();
        this._node = base.getNode();
        this._payload = base.getPayload();
        if (base instanceof TransmitPacketInputImpl) {
            TransmitPacketInputImpl impl = (TransmitPacketInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof RawPacket) {
            this._ingress = ((RawPacket)arg).getIngress();
            this._payload = ((RawPacket)arg).getPayload();
            isValidArg = true;
        }
        if (arg instanceof ActionList) {
            this._action = ((ActionList)arg).getAction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket, org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.ActionList] \nbut was: " + arg);
        }
    }

    public List<Action> getAction() {
        return this._action;
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public ConnectionCookie getConnectionCookie() {
        return this._connectionCookie;
    }

    public NodeConnectorRef getEgress() {
        return this._egress;
    }

    public NodeConnectorRef getIngress() {
        return this._ingress;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public byte[] getPayload() {
        return this._payload == null ? null : (byte[])this._payload.clone();
    }

    public <E extends Augmentation<TransmitPacketInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TransmitPacketInputBuilder setAction(List<Action> value) {
        this._action = value;
        return this;
    }

    private static void checkBufferIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public TransmitPacketInputBuilder setBufferId(Long value) {
        if (value != null) {
            TransmitPacketInputBuilder.checkBufferIdRange(value);
        }
        this._bufferId = value;
        return this;
    }

    public TransmitPacketInputBuilder setConnectionCookie(ConnectionCookie value) {
        this._connectionCookie = value;
        return this;
    }

    public TransmitPacketInputBuilder setEgress(NodeConnectorRef value) {
        this._egress = value;
        return this;
    }

    public TransmitPacketInputBuilder setIngress(NodeConnectorRef value) {
        this._ingress = value;
        return this;
    }

    public TransmitPacketInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public TransmitPacketInputBuilder setPayload(byte[] value) {
        this._payload = value;
        return this;
    }

    public TransmitPacketInputBuilder addAugmentation(Class<? extends Augmentation<TransmitPacketInput>> augmentationType, Augmentation<TransmitPacketInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TransmitPacketInputBuilder removeAugmentation(Class<? extends Augmentation<TransmitPacketInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TransmitPacketInput build() {
        return new TransmitPacketInputImpl(this);
    }

    private static final class TransmitPacketInputImpl
    implements TransmitPacketInput {
        private final List<Action> _action;
        private final Long _bufferId;
        private final ConnectionCookie _connectionCookie;
        private final NodeConnectorRef _egress;
        private final NodeConnectorRef _ingress;
        private final NodeRef _node;
        private final byte[] _payload;
        private Map<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TransmitPacketInput> getImplementedInterface() {
            return TransmitPacketInput.class;
        }

        private TransmitPacketInputImpl(TransmitPacketInputBuilder base) {
            this._action = base.getAction();
            this._bufferId = base.getBufferId();
            this._connectionCookie = base.getConnectionCookie();
            this._egress = base.getEgress();
            this._ingress = base.getIngress();
            this._node = base.getNode();
            this._payload = base.getPayload();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>>(base.augmentation);
                }
            }
        }

        public List<Action> getAction() {
            return this._action;
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public ConnectionCookie getConnectionCookie() {
            return this._connectionCookie;
        }

        @Override
        public NodeConnectorRef getEgress() {
            return this._egress;
        }

        @Override
        public NodeConnectorRef getIngress() {
            return this._ingress;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public byte[] getPayload() {
            return this._payload == null ? null : (byte[])this._payload.clone();
        }

        public <E extends Augmentation<TransmitPacketInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._action);
            result = 31 * result + Objects.hashCode(this._bufferId);
            result = 31 * result + Objects.hashCode(this._connectionCookie);
            result = 31 * result + Objects.hashCode(this._egress);
            result = 31 * result + Objects.hashCode(this._ingress);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Arrays.hashCode(this._payload);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TransmitPacketInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TransmitPacketInput other = (TransmitPacketInput)obj;
            if (!Objects.equals(this._action, other.getAction())) {
                return false;
            }
            if (!Objects.equals(this._bufferId, other.getBufferId())) {
                return false;
            }
            if (!Objects.equals(this._connectionCookie, other.getConnectionCookie())) {
                return false;
            }
            if (!Objects.equals(this._egress, other.getEgress())) {
                return false;
            }
            if (!Objects.equals(this._ingress, other.getIngress())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Arrays.equals(this._payload, other.getPayload())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TransmitPacketInputImpl otherImpl = (TransmitPacketInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TransmitPacketInput>>, Augmentation<TransmitPacketInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TransmitPacketInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._action != null) {
                builder.append("_action=");
                builder.append(this._action);
                builder.append(", ");
            }
            if (this._bufferId != null) {
                builder.append("_bufferId=");
                builder.append(this._bufferId);
                builder.append(", ");
            }
            if (this._connectionCookie != null) {
                builder.append("_connectionCookie=");
                builder.append(this._connectionCookie);
                builder.append(", ");
            }
            if (this._egress != null) {
                builder.append("_egress=");
                builder.append(this._egress);
                builder.append(", ");
            }
            if (this._ingress != null) {
                builder.append("_ingress=");
                builder.append(this._ingress);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._payload != null) {
                builder.append("_payload=");
                builder.append(Arrays.toString(this._payload));
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

