/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.ConnectionCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.PacketReceived;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.packet.received.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketReceivedBuilder
implements Builder<PacketReceived> {
    private ConnectionCookie _connectionCookie;
    private FlowCookie _flowCookie;
    private NodeConnectorRef _ingress;
    private Match _match;
    private Class<? extends PacketInReason> _packetInReason;
    private byte[] _payload;
    private TableId _tableId;
    Map<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> augmentation = Collections.emptyMap();

    public PacketReceivedBuilder() {
    }

    public PacketReceivedBuilder(RawPacket arg) {
        this._ingress = arg.getIngress();
        this._payload = arg.getPayload();
    }

    public PacketReceivedBuilder(PacketReceived base) {
        AugmentationHolder casted;
        this._connectionCookie = base.getConnectionCookie();
        this._flowCookie = base.getFlowCookie();
        this._ingress = base.getIngress();
        this._match = base.getMatch();
        this._packetInReason = base.getPacketInReason();
        this._payload = base.getPayload();
        this._tableId = base.getTableId();
        if (base instanceof PacketReceivedImpl) {
            PacketReceivedImpl impl = (PacketReceivedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RawPacket) {
            this._ingress = ((RawPacket)arg).getIngress();
            this._payload = ((RawPacket)arg).getPayload();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.packet.service.rev130709.RawPacket] \nbut was: " + arg);
        }
    }

    public ConnectionCookie getConnectionCookie() {
        return this._connectionCookie;
    }

    public FlowCookie getFlowCookie() {
        return this._flowCookie;
    }

    public NodeConnectorRef getIngress() {
        return this._ingress;
    }

    public Match getMatch() {
        return this._match;
    }

    public Class<? extends PacketInReason> getPacketInReason() {
        return this._packetInReason;
    }

    public byte[] getPayload() {
        return this._payload == null ? null : (byte[])this._payload.clone();
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<PacketReceived>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PacketReceivedBuilder setConnectionCookie(ConnectionCookie value) {
        this._connectionCookie = value;
        return this;
    }

    public PacketReceivedBuilder setFlowCookie(FlowCookie value) {
        this._flowCookie = value;
        return this;
    }

    public PacketReceivedBuilder setIngress(NodeConnectorRef value) {
        this._ingress = value;
        return this;
    }

    public PacketReceivedBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public PacketReceivedBuilder setPacketInReason(Class<? extends PacketInReason> value) {
        this._packetInReason = value;
        return this;
    }

    public PacketReceivedBuilder setPayload(byte[] value) {
        this._payload = value;
        return this;
    }

    public PacketReceivedBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    public PacketReceivedBuilder addAugmentation(Class<? extends Augmentation<PacketReceived>> augmentationType, Augmentation<PacketReceived> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketReceivedBuilder removeAugmentation(Class<? extends Augmentation<PacketReceived>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketReceived build() {
        return new PacketReceivedImpl(this);
    }

    private static final class PacketReceivedImpl
    implements PacketReceived {
        private final ConnectionCookie _connectionCookie;
        private final FlowCookie _flowCookie;
        private final NodeConnectorRef _ingress;
        private final Match _match;
        private final Class<? extends PacketInReason> _packetInReason;
        private final byte[] _payload;
        private final TableId _tableId;
        private Map<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PacketReceived> getImplementedInterface() {
            return PacketReceived.class;
        }

        private PacketReceivedImpl(PacketReceivedBuilder base) {
            this._connectionCookie = base.getConnectionCookie();
            this._flowCookie = base.getFlowCookie();
            this._ingress = base.getIngress();
            this._match = base.getMatch();
            this._packetInReason = base.getPacketInReason();
            this._payload = base.getPayload();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>>(base.augmentation);
                }
            }
        }

        @Override
        public ConnectionCookie getConnectionCookie() {
            return this._connectionCookie;
        }

        @Override
        public FlowCookie getFlowCookie() {
            return this._flowCookie;
        }

        @Override
        public NodeConnectorRef getIngress() {
            return this._ingress;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public Class<? extends PacketInReason> getPacketInReason() {
            return this._packetInReason;
        }

        @Override
        public byte[] getPayload() {
            return this._payload == null ? null : (byte[])this._payload.clone();
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<PacketReceived>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._connectionCookie);
            result = 31 * result + Objects.hashCode(this._flowCookie);
            result = 31 * result + Objects.hashCode(this._ingress);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._packetInReason);
            result = 31 * result + Arrays.hashCode(this._payload);
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketReceived.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketReceived other = (PacketReceived)obj;
            if (!Objects.equals(this._connectionCookie, other.getConnectionCookie())) {
                return false;
            }
            if (!Objects.equals(this._flowCookie, other.getFlowCookie())) {
                return false;
            }
            if (!Objects.equals(this._ingress, other.getIngress())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._packetInReason, other.getPacketInReason())) {
                return false;
            }
            if (!Arrays.equals(this._payload, other.getPayload())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketReceivedImpl otherImpl = (PacketReceivedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketReceived>>, Augmentation<PacketReceived>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PacketReceived [";
            StringBuilder builder = new StringBuilder(name);
            if (this._connectionCookie != null) {
                builder.append("_connectionCookie=");
                builder.append(this._connectionCookie);
                builder.append(", ");
            }
            if (this._flowCookie != null) {
                builder.append("_flowCookie=");
                builder.append(this._flowCookie);
                builder.append(", ");
            }
            if (this._ingress != null) {
                builder.append("_ingress=");
                builder.append(this._ingress);
                builder.append(", ");
            }
            if (this._match != null) {
                builder.append("_match=");
                builder.append(this._match);
                builder.append(", ");
            }
            if (this._packetInReason != null) {
                builder.append("_packetInReason=");
                builder.append(this._packetInReason);
                builder.append(", ");
            }
            if (this._payload != null) {
                builder.append("_payload=");
                builder.append(Arrays.toString(this._payload));
                builder.append(", ");
            }
            if (this._tableId != null) {
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

