/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.BaseNodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.node.error.reference.ObjectReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410.TableFeaturesErrorNotification;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableFeaturesErrorNotificationBuilder
implements Builder<TableFeaturesErrorNotification> {
    private Integer _code;
    private String _data;
    private NodeRef _node;
    private ObjectReference _objectReference;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private ErrorType _type;
    Map<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>> augmentation = Collections.emptyMap();

    public TableFeaturesErrorNotificationBuilder() {
    }

    public TableFeaturesErrorNotificationBuilder(BaseNodeErrorNotification arg) {
        this._node = arg.getNode();
    }

    public TableFeaturesErrorNotificationBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public TableFeaturesErrorNotificationBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public TableFeaturesErrorNotificationBuilder(NodeErrorReference arg) {
        this._objectReference = arg.getObjectReference();
    }

    public TableFeaturesErrorNotificationBuilder(ErrorMessage arg) {
        this._type = arg.getType();
        this._code = arg.getCode();
        this._data = arg.getData();
    }

    public TableFeaturesErrorNotificationBuilder(TableFeaturesErrorNotification base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._data = base.getData();
        this._node = base.getNode();
        this._objectReference = base.getObjectReference();
        this._transactionId = base.getTransactionId();
        this._transactionUri = base.getTransactionUri();
        this._type = base.getType();
        if (base instanceof TableFeaturesErrorNotificationImpl) {
            TableFeaturesErrorNotificationImpl impl = (TableFeaturesErrorNotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ErrorMessage) {
            this._type = ((ErrorMessage)arg).getType();
            this._code = ((ErrorMessage)arg).getCode();
            this._data = ((ErrorMessage)arg).getData();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof NodeErrorReference) {
            this._objectReference = ((NodeErrorReference)arg).getObjectReference();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (arg instanceof BaseNodeErrorNotification) {
            this._node = ((BaseNodeErrorNotification)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorReference, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.BaseNodeErrorNotification] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getData() {
        return this._data;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public ObjectReference getObjectReference() {
        return this._objectReference;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public ErrorType getType() {
        return this._type;
    }

    public <E extends Augmentation<TableFeaturesErrorNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public TableFeaturesErrorNotificationBuilder setCode(Integer value) {
        if (value != null) {
            TableFeaturesErrorNotificationBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder setObjectReference(ObjectReference value) {
        this._objectReference = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public TableFeaturesErrorNotificationBuilder addAugmentation(Class<? extends Augmentation<TableFeaturesErrorNotification>> augmentationType, Augmentation<TableFeaturesErrorNotification> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableFeaturesErrorNotificationBuilder removeAugmentation(Class<? extends Augmentation<TableFeaturesErrorNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TableFeaturesErrorNotification build() {
        return new TableFeaturesErrorNotificationImpl(this);
    }

    private static final class TableFeaturesErrorNotificationImpl
    implements TableFeaturesErrorNotification {
        private final Integer _code;
        private final String _data;
        private final NodeRef _node;
        private final ObjectReference _objectReference;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private final ErrorType _type;
        private Map<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TableFeaturesErrorNotification> getImplementedInterface() {
            return TableFeaturesErrorNotification.class;
        }

        private TableFeaturesErrorNotificationImpl(TableFeaturesErrorNotificationBuilder base) {
            this._code = base.getCode();
            this._data = base.getData();
            this._node = base.getNode();
            this._objectReference = base.getObjectReference();
            this._transactionId = base.getTransactionId();
            this._transactionUri = base.getTransactionUri();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public ObjectReference getObjectReference() {
            return this._objectReference;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        public <E extends Augmentation<TableFeaturesErrorNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._code);
            result = 31 * result + Objects.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._objectReference);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TableFeaturesErrorNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TableFeaturesErrorNotification other = (TableFeaturesErrorNotification)obj;
            if (!Objects.equals(this._code, other.getCode())) {
                return false;
            }
            if (!Objects.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._objectReference, other.getObjectReference())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableFeaturesErrorNotificationImpl otherImpl = (TableFeaturesErrorNotificationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TableFeaturesErrorNotification>>, Augmentation<TableFeaturesErrorNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TableFeaturesErrorNotification [";
            StringBuilder builder = new StringBuilder(name);
            if (this._code != null) {
                builder.append("_code=");
                builder.append(this._code);
                builder.append(", ");
            }
            if (this._data != null) {
                builder.append("_data=");
                builder.append(this._data);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._objectReference != null) {
                builder.append("_objectReference=");
                builder.append(this._objectReference);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

