/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410.NodeErrorContainer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeErrorContainerBuilder
implements Builder<NodeErrorContainer> {
    private Integer _code;
    private String _data;
    private ErrorType _type;
    Map<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>> augmentation = Collections.emptyMap();

    public NodeErrorContainerBuilder() {
    }

    public NodeErrorContainerBuilder(ErrorMessage arg) {
        this._type = arg.getType();
        this._code = arg.getCode();
        this._data = arg.getData();
    }

    public NodeErrorContainerBuilder(NodeErrorContainer base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._data = base.getData();
        this._type = base.getType();
        if (base instanceof NodeErrorContainerImpl) {
            NodeErrorContainerImpl impl = (NodeErrorContainerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ErrorMessage) {
            this._type = ((ErrorMessage)arg).getType();
            this._code = ((ErrorMessage)arg).getCode();
            this._data = ((ErrorMessage)arg).getData();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getData() {
        return this._data;
    }

    public ErrorType getType() {
        return this._type;
    }

    public <E extends Augmentation<NodeErrorContainer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NodeErrorContainerBuilder setCode(Integer value) {
        if (value != null) {
            NodeErrorContainerBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    public NodeErrorContainerBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public NodeErrorContainerBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public NodeErrorContainerBuilder addAugmentation(Class<? extends Augmentation<NodeErrorContainer>> augmentationType, Augmentation<NodeErrorContainer> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeErrorContainerBuilder removeAugmentation(Class<? extends Augmentation<NodeErrorContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeErrorContainer build() {
        return new NodeErrorContainerImpl(this);
    }

    private static final class NodeErrorContainerImpl
    implements NodeErrorContainer {
        private final Integer _code;
        private final String _data;
        private final ErrorType _type;
        private Map<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NodeErrorContainer> getImplementedInterface() {
            return NodeErrorContainer.class;
        }

        private NodeErrorContainerImpl(NodeErrorContainerBuilder base) {
            this._code = base.getCode();
            this._data = base.getData();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        public <E extends Augmentation<NodeErrorContainer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._code);
            result = 31 * result + Objects.hashCode(this._data);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeErrorContainer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NodeErrorContainer other = (NodeErrorContainer)obj;
            if (!Objects.equals(this._code, other.getCode())) {
                return false;
            }
            if (!Objects.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeErrorContainerImpl otherImpl = (NodeErrorContainerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NodeErrorContainer>>, Augmentation<NodeErrorContainer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NodeErrorContainer [";
            StringBuilder builder = new StringBuilder(name);
            if (this._code != null) {
                builder.append("_code=");
                builder.append(this._code);
                builder.append(", ");
            }
            if (this._data != null) {
                builder.append("_data=");
                builder.append(this._data);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

