/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.BaseNodeErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.node.error.reference.ObjectReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.node.error.service.rev140410.BadMatchErrorNotification;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BadMatchErrorNotificationBuilder
implements Builder<BadMatchErrorNotification> {
    private Integer _code;
    private String _data;
    private NodeRef _node;
    private ObjectReference _objectReference;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private ErrorType _type;
    Map<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>> augmentation = Collections.emptyMap();

    public BadMatchErrorNotificationBuilder() {
    }

    public BadMatchErrorNotificationBuilder(BaseNodeErrorNotification arg) {
        this._node = arg.getNode();
    }

    public BadMatchErrorNotificationBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public BadMatchErrorNotificationBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public BadMatchErrorNotificationBuilder(NodeErrorReference arg) {
        this._objectReference = arg.getObjectReference();
    }

    public BadMatchErrorNotificationBuilder(ErrorMessage arg) {
        this._type = arg.getType();
        this._code = arg.getCode();
        this._data = arg.getData();
    }

    public BadMatchErrorNotificationBuilder(BadMatchErrorNotification base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._data = base.getData();
        this._node = base.getNode();
        this._objectReference = base.getObjectReference();
        this._transactionId = base.getTransactionId();
        this._transactionUri = base.getTransactionUri();
        this._type = base.getType();
        if (base instanceof BadMatchErrorNotificationImpl) {
            BadMatchErrorNotificationImpl impl = (BadMatchErrorNotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ErrorMessage) {
            this._type = ((ErrorMessage)arg).getType();
            this._code = ((ErrorMessage)arg).getCode();
            this._data = ((ErrorMessage)arg).getData();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof NodeErrorReference) {
            this._objectReference = ((NodeErrorReference)arg).getObjectReference();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (arg instanceof BaseNodeErrorNotification) {
            this._node = ((BaseNodeErrorNotification)arg).getNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeErrorReference, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.BaseNodeErrorNotification] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getData() {
        return this._data;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public ObjectReference getObjectReference() {
        return this._objectReference;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public ErrorType getType() {
        return this._type;
    }

    public <E extends Augmentation<BadMatchErrorNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BadMatchErrorNotificationBuilder setCode(Integer value) {
        if (value != null) {
            BadMatchErrorNotificationBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder setObjectReference(ObjectReference value) {
        this._objectReference = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public BadMatchErrorNotificationBuilder addAugmentation(Class<? extends Augmentation<BadMatchErrorNotification>> augmentationType, Augmentation<BadMatchErrorNotification> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BadMatchErrorNotificationBuilder removeAugmentation(Class<? extends Augmentation<BadMatchErrorNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BadMatchErrorNotification build() {
        return new BadMatchErrorNotificationImpl(this);
    }

    private static final class BadMatchErrorNotificationImpl
    implements BadMatchErrorNotification {
        private final Integer _code;
        private final String _data;
        private final NodeRef _node;
        private final ObjectReference _objectReference;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private final ErrorType _type;
        private Map<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BadMatchErrorNotification> getImplementedInterface() {
            return BadMatchErrorNotification.class;
        }

        private BadMatchErrorNotificationImpl(BadMatchErrorNotificationBuilder base) {
            this._code = base.getCode();
            this._data = base.getData();
            this._node = base.getNode();
            this._objectReference = base.getObjectReference();
            this._transactionId = base.getTransactionId();
            this._transactionUri = base.getTransactionUri();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public ObjectReference getObjectReference() {
            return this._objectReference;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        public <E extends Augmentation<BadMatchErrorNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._code);
            result = 31 * result + Objects.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._objectReference);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BadMatchErrorNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BadMatchErrorNotification other = (BadMatchErrorNotification)obj;
            if (!Objects.equals(this._code, other.getCode())) {
                return false;
            }
            if (!Objects.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._objectReference, other.getObjectReference())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BadMatchErrorNotificationImpl otherImpl = (BadMatchErrorNotificationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BadMatchErrorNotification>>, Augmentation<BadMatchErrorNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BadMatchErrorNotification [";
            StringBuilder builder = new StringBuilder(name);
            if (this._code != null) {
                builder.append("_code=");
                builder.append(this._code);
                builder.append(", ");
            }
            if (this._data != null) {
                builder.append("_data=");
                builder.append(this._data);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._objectReference != null) {
                builder.append("_objectReference=");
                builder.append(this._objectReference);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

