/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.module.config.rev141015;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.module.config.rev141015.NodeConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.module.config.rev141015.SetConfigInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetConfigInputBuilder
implements Builder<SetConfigInput> {
    private String _flag;
    private Integer _missSearchLength;
    private NodeRef _node;
    private TransactionId _transactionId;
    Map<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> augmentation = Collections.emptyMap();

    public SetConfigInputBuilder() {
    }

    public SetConfigInputBuilder(NodeConfig arg) {
        this._flag = arg.getFlag();
        this._missSearchLength = arg.getMissSearchLength();
    }

    public SetConfigInputBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public SetConfigInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public SetConfigInputBuilder(SetConfigInput base) {
        AugmentationHolder casted;
        this._flag = base.getFlag();
        this._missSearchLength = base.getMissSearchLength();
        this._node = base.getNode();
        this._transactionId = base.getTransactionId();
        if (base instanceof SetConfigInputImpl) {
            SetConfigInputImpl impl = (SetConfigInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof NodeConfig) {
            this._flag = ((NodeConfig)arg).getFlag();
            this._missSearchLength = ((NodeConfig)arg).getMissSearchLength();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.module.config.rev141015.NodeConfig, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public String getFlag() {
        return this._flag;
    }

    public Integer getMissSearchLength() {
        return this._missSearchLength;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public <E extends Augmentation<SetConfigInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetConfigInputBuilder setFlag(String value) {
        this._flag = value;
        return this;
    }

    private static void checkMissSearchLengthRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SetConfigInputBuilder setMissSearchLength(Integer value) {
        if (value != null) {
            SetConfigInputBuilder.checkMissSearchLengthRange(value);
        }
        this._missSearchLength = value;
        return this;
    }

    public SetConfigInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public SetConfigInputBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public SetConfigInputBuilder addAugmentation(Class<? extends Augmentation<SetConfigInput>> augmentationType, Augmentation<SetConfigInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SetConfigInputBuilder removeAugmentation(Class<? extends Augmentation<SetConfigInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetConfigInput build() {
        return new SetConfigInputImpl(this);
    }

    private static final class SetConfigInputImpl
    implements SetConfigInput {
        private final String _flag;
        private final Integer _missSearchLength;
        private final NodeRef _node;
        private final TransactionId _transactionId;
        private Map<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetConfigInput> getImplementedInterface() {
            return SetConfigInput.class;
        }

        private SetConfigInputImpl(SetConfigInputBuilder base) {
            this._flag = base.getFlag();
            this._missSearchLength = base.getMissSearchLength();
            this._node = base.getNode();
            this._transactionId = base.getTransactionId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>>(base.augmentation);
                }
            }
        }

        @Override
        public String getFlag() {
            return this._flag;
        }

        @Override
        public Integer getMissSearchLength() {
            return this._missSearchLength;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        public <E extends Augmentation<SetConfigInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flag);
            result = 31 * result + Objects.hashCode(this._missSearchLength);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._transactionId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetConfigInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetConfigInput other = (SetConfigInput)obj;
            if (!Objects.equals(this._flag, other.getFlag())) {
                return false;
            }
            if (!Objects.equals(this._missSearchLength, other.getMissSearchLength())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetConfigInputImpl otherImpl = (SetConfigInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetConfigInput>>, Augmentation<SetConfigInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetConfigInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flag != null) {
                builder.append("_flag=");
                builder.append(this._flag);
                builder.append(", ");
            }
            if (this._missSearchLength != null) {
                builder.append("_missSearchLength=");
                builder.append(this._missSearchLength);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

