/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.batch.meter.output.list.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.batch.meter.output.list.grouping.BatchFailedMetersOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.batch.meter.output.list.grouping.BatchFailedMetersOutputKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchFailedMetersOutputBuilder
implements Builder<BatchFailedMetersOutput> {
    private Integer _batchOrder;
    private BatchFailedMetersOutputKey _key;
    private MeterId _meterId;
    Map<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>> augmentation = Collections.emptyMap();

    public BatchFailedMetersOutputBuilder() {
    }

    public BatchFailedMetersOutputBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public BatchFailedMetersOutputBuilder(BatchFailedMetersOutput base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchFailedMetersOutputKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._meterId = base.getMeterId();
        if (base instanceof BatchFailedMetersOutputImpl) {
            BatchFailedMetersOutputImpl impl = (BatchFailedMetersOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping] \nbut was: " + arg);
        }
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public BatchFailedMetersOutputKey getKey() {
        return this._key;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public <E extends Augmentation<BatchFailedMetersOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BatchFailedMetersOutputBuilder setBatchOrder(Integer value) {
        if (value != null) {
            BatchFailedMetersOutputBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public BatchFailedMetersOutputBuilder setKey(BatchFailedMetersOutputKey value) {
        this._key = value;
        return this;
    }

    public BatchFailedMetersOutputBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public BatchFailedMetersOutputBuilder addAugmentation(Class<? extends Augmentation<BatchFailedMetersOutput>> augmentationType, Augmentation<BatchFailedMetersOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchFailedMetersOutputBuilder removeAugmentation(Class<? extends Augmentation<BatchFailedMetersOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BatchFailedMetersOutput build() {
        return new BatchFailedMetersOutputImpl(this);
    }

    private static final class BatchFailedMetersOutputImpl
    implements BatchFailedMetersOutput {
        private final Integer _batchOrder;
        private final BatchFailedMetersOutputKey _key;
        private final MeterId _meterId;
        private Map<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BatchFailedMetersOutput> getImplementedInterface() {
            return BatchFailedMetersOutput.class;
        }

        private BatchFailedMetersOutputImpl(BatchFailedMetersOutputBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchFailedMetersOutputKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._meterId = base.getMeterId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public BatchFailedMetersOutputKey getKey() {
            return this._key;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        public <E extends Augmentation<BatchFailedMetersOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._meterId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BatchFailedMetersOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BatchFailedMetersOutput other = (BatchFailedMetersOutput)obj;
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchFailedMetersOutputImpl otherImpl = (BatchFailedMetersOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BatchFailedMetersOutput>>, Augmentation<BatchFailedMetersOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BatchFailedMetersOutput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._meterId != null) {
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

