/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.add.meters.batch.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.add.meters.batch.input.BatchAddMeters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.add.meters.batch.input.BatchAddMetersKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchAddMetersBuilder
implements Builder<BatchAddMeters> {
    private String _containerName;
    private MeterFlags _flags;
    private BatchAddMetersKey _key;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private MeterRef _meterRef;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>> augmentation = Collections.emptyMap();

    public BatchAddMetersBuilder() {
    }

    public BatchAddMetersBuilder(Meter arg) {
        this._flags = arg.getFlags();
        this._meterId = arg.getMeterId();
        this._barrier = arg.isBarrier();
        this._meterName = arg.getMeterName();
        this._containerName = arg.getContainerName();
        this._meterBandHeaders = arg.getMeterBandHeaders();
    }

    public BatchAddMetersBuilder(BatchAddMeters base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchAddMetersKey(base.getMeterId());
            this._meterId = base.getMeterId();
        } else {
            this._key = base.getKey();
            this._meterId = this._key.getMeterId();
        }
        this._containerName = base.getContainerName();
        this._flags = base.getFlags();
        this._meterBandHeaders = base.getMeterBandHeaders();
        this._meterName = base.getMeterName();
        this._meterRef = base.getMeterRef();
        this._barrier = base.isBarrier();
        if (base instanceof BatchAddMetersImpl) {
            BatchAddMetersImpl impl = (BatchAddMetersImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Meter) {
            this._flags = ((Meter)arg).getFlags();
            this._meterId = ((Meter)arg).getMeterId();
            this._barrier = ((Meter)arg).isBarrier();
            this._meterName = ((Meter)arg).getMeterName();
            this._containerName = ((Meter)arg).getContainerName();
            this._meterBandHeaders = ((Meter)arg).getMeterBandHeaders();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter] \nbut was: " + arg);
        }
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public BatchAddMetersKey getKey() {
        return this._key;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public MeterRef getMeterRef() {
        return this._meterRef;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<BatchAddMeters>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BatchAddMetersBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public BatchAddMetersBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public BatchAddMetersBuilder setKey(BatchAddMetersKey value) {
        this._key = value;
        return this;
    }

    public BatchAddMetersBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    public BatchAddMetersBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public BatchAddMetersBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public BatchAddMetersBuilder setMeterRef(MeterRef value) {
        this._meterRef = value;
        return this;
    }

    public BatchAddMetersBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public BatchAddMetersBuilder addAugmentation(Class<? extends Augmentation<BatchAddMeters>> augmentationType, Augmentation<BatchAddMeters> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchAddMetersBuilder removeAugmentation(Class<? extends Augmentation<BatchAddMeters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BatchAddMeters build() {
        return new BatchAddMetersImpl(this);
    }

    private static final class BatchAddMetersImpl
    implements BatchAddMeters {
        private final String _containerName;
        private final MeterFlags _flags;
        private final BatchAddMetersKey _key;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private final MeterRef _meterRef;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BatchAddMeters> getImplementedInterface() {
            return BatchAddMeters.class;
        }

        private BatchAddMetersImpl(BatchAddMetersBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchAddMetersKey(base.getMeterId());
                this._meterId = base.getMeterId();
            } else {
                this._key = base.getKey();
                this._meterId = this._key.getMeterId();
            }
            this._containerName = base.getContainerName();
            this._flags = base.getFlags();
            this._meterBandHeaders = base.getMeterBandHeaders();
            this._meterName = base.getMeterName();
            this._meterRef = base.getMeterRef();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>>(base.augmentation);
                }
            }
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        @Override
        public BatchAddMetersKey getKey() {
            return this._key;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        @Override
        public MeterRef getMeterRef() {
            return this._meterRef;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<BatchAddMeters>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._containerName);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._meterBandHeaders);
            result = 31 * result + Objects.hashCode(this._meterId);
            result = 31 * result + Objects.hashCode(this._meterName);
            result = 31 * result + Objects.hashCode(this._meterRef);
            result = 31 * result + Objects.hashCode(this._barrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BatchAddMeters.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BatchAddMeters other = (BatchAddMeters)obj;
            if (!Objects.equals(this._containerName, other.getContainerName())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._meterBandHeaders, other.getMeterBandHeaders())) {
                return false;
            }
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (!Objects.equals(this._meterName, other.getMeterName())) {
                return false;
            }
            if (!Objects.equals(this._meterRef, other.getMeterRef())) {
                return false;
            }
            if (!Objects.equals(this._barrier, other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchAddMetersImpl otherImpl = (BatchAddMetersImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BatchAddMeters>>, Augmentation<BatchAddMeters>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BatchAddMeters [";
            StringBuilder builder = new StringBuilder(name);
            if (this._containerName != null) {
                builder.append("_containerName=");
                builder.append(this._containerName);
                builder.append(", ");
            }
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._meterBandHeaders != null) {
                builder.append("_meterBandHeaders=");
                builder.append(this._meterBandHeaders);
                builder.append(", ");
            }
            if (this._meterId != null) {
                builder.append("_meterId=");
                builder.append(this._meterId);
                builder.append(", ");
            }
            if (this._meterName != null) {
                builder.append("_meterName=");
                builder.append(this._meterName);
                builder.append(", ");
            }
            if (this._meterRef != null) {
                builder.append("_meterRef=");
                builder.append(this._meterRef);
                builder.append(", ");
            }
            if (this._barrier != null) {
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

