/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.UpdateMetersBatchInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meters.service.rev160316.update.meters.batch.input.BatchUpdateMeters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.BarrierSuffix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateMetersBatchInputBuilder
implements Builder<UpdateMetersBatchInput> {
    private List<BatchUpdateMeters> _batchUpdateMeters;
    private NodeRef _node;
    private Boolean _barrierAfter;
    Map<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>> augmentation = Collections.emptyMap();

    public UpdateMetersBatchInputBuilder() {
    }

    public UpdateMetersBatchInputBuilder(BarrierSuffix arg) {
        this._barrierAfter = arg.isBarrierAfter();
    }

    public UpdateMetersBatchInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateMetersBatchInputBuilder(UpdateMetersBatchInput base) {
        AugmentationHolder casted;
        this._batchUpdateMeters = base.getBatchUpdateMeters();
        this._node = base.getNode();
        this._barrierAfter = base.isBarrierAfter();
        if (base instanceof UpdateMetersBatchInputImpl) {
            UpdateMetersBatchInputImpl impl = (UpdateMetersBatchInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof BarrierSuffix) {
            this._barrierAfter = ((BarrierSuffix)arg).isBarrierAfter();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.BarrierSuffix] \nbut was: " + arg);
        }
    }

    public List<BatchUpdateMeters> getBatchUpdateMeters() {
        return this._batchUpdateMeters;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Boolean isBarrierAfter() {
        return this._barrierAfter;
    }

    public <E extends Augmentation<UpdateMetersBatchInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateMetersBatchInputBuilder setBatchUpdateMeters(List<BatchUpdateMeters> value) {
        this._batchUpdateMeters = value;
        return this;
    }

    public UpdateMetersBatchInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateMetersBatchInputBuilder setBarrierAfter(Boolean value) {
        this._barrierAfter = value;
        return this;
    }

    public UpdateMetersBatchInputBuilder addAugmentation(Class<? extends Augmentation<UpdateMetersBatchInput>> augmentationType, Augmentation<UpdateMetersBatchInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateMetersBatchInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateMetersBatchInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateMetersBatchInput build() {
        return new UpdateMetersBatchInputImpl(this);
    }

    private static final class UpdateMetersBatchInputImpl
    implements UpdateMetersBatchInput {
        private final List<BatchUpdateMeters> _batchUpdateMeters;
        private final NodeRef _node;
        private final Boolean _barrierAfter;
        private Map<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateMetersBatchInput> getImplementedInterface() {
            return UpdateMetersBatchInput.class;
        }

        private UpdateMetersBatchInputImpl(UpdateMetersBatchInputBuilder base) {
            this._batchUpdateMeters = base.getBatchUpdateMeters();
            this._node = base.getNode();
            this._barrierAfter = base.isBarrierAfter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BatchUpdateMeters> getBatchUpdateMeters() {
            return this._batchUpdateMeters;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Boolean isBarrierAfter() {
            return this._barrierAfter;
        }

        public <E extends Augmentation<UpdateMetersBatchInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchUpdateMeters);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._barrierAfter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateMetersBatchInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateMetersBatchInput other = (UpdateMetersBatchInput)obj;
            if (!Objects.equals(this._batchUpdateMeters, other.getBatchUpdateMeters())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._barrierAfter, other.isBarrierAfter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateMetersBatchInputImpl otherImpl = (UpdateMetersBatchInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateMetersBatchInput>>, Augmentation<UpdateMetersBatchInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UpdateMetersBatchInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchUpdateMeters != null) {
                builder.append("_batchUpdateMeters=");
                builder.append(this._batchUpdateMeters);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._barrierAfter != null) {
                builder.append("_barrierAfter=");
                builder.append(this._barrierAfter);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

