/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.OriginalMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.UpdatedMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateMeterInputBuilder
implements Builder<UpdateMeterInput> {
    private MeterRef _meterRef;
    private NodeRef _node;
    private OriginalMeter _originalMeter;
    private Uri _transactionUri;
    private UpdatedMeter _updatedMeter;
    Map<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>> augmentation = Collections.emptyMap();

    public UpdateMeterInputBuilder() {
    }

    public UpdateMeterInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateMeterInputBuilder(MeterUpdate arg) {
        this._originalMeter = arg.getOriginalMeter();
        this._updatedMeter = arg.getUpdatedMeter();
        this._node = arg.getNode();
    }

    public UpdateMeterInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateMeterInputBuilder(UpdateMeterInput base) {
        AugmentationHolder casted;
        this._meterRef = base.getMeterRef();
        this._node = base.getNode();
        this._originalMeter = base.getOriginalMeter();
        this._transactionUri = base.getTransactionUri();
        this._updatedMeter = base.getUpdatedMeter();
        if (base instanceof UpdateMeterInputImpl) {
            UpdateMeterInputImpl impl = (UpdateMeterInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof MeterUpdate) {
            this._originalMeter = ((MeterUpdate)arg).getOriginalMeter();
            this._updatedMeter = ((MeterUpdate)arg).getUpdatedMeter();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.MeterUpdate] \nbut was: " + arg);
        }
    }

    public MeterRef getMeterRef() {
        return this._meterRef;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalMeter getOriginalMeter() {
        return this._originalMeter;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public UpdatedMeter getUpdatedMeter() {
        return this._updatedMeter;
    }

    public <E extends Augmentation<UpdateMeterInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateMeterInputBuilder setMeterRef(MeterRef value) {
        this._meterRef = value;
        return this;
    }

    public UpdateMeterInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateMeterInputBuilder setOriginalMeter(OriginalMeter value) {
        this._originalMeter = value;
        return this;
    }

    public UpdateMeterInputBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public UpdateMeterInputBuilder setUpdatedMeter(UpdatedMeter value) {
        this._updatedMeter = value;
        return this;
    }

    public UpdateMeterInputBuilder addAugmentation(Class<? extends Augmentation<UpdateMeterInput>> augmentationType, Augmentation<UpdateMeterInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateMeterInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateMeterInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateMeterInput build() {
        return new UpdateMeterInputImpl(this);
    }

    private static final class UpdateMeterInputImpl
    implements UpdateMeterInput {
        private final MeterRef _meterRef;
        private final NodeRef _node;
        private final OriginalMeter _originalMeter;
        private final Uri _transactionUri;
        private final UpdatedMeter _updatedMeter;
        private Map<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateMeterInput> getImplementedInterface() {
            return UpdateMeterInput.class;
        }

        private UpdateMeterInputImpl(UpdateMeterInputBuilder base) {
            this._meterRef = base.getMeterRef();
            this._node = base.getNode();
            this._originalMeter = base.getOriginalMeter();
            this._transactionUri = base.getTransactionUri();
            this._updatedMeter = base.getUpdatedMeter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>>(base.augmentation);
                }
            }
        }

        @Override
        public MeterRef getMeterRef() {
            return this._meterRef;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalMeter getOriginalMeter() {
            return this._originalMeter;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public UpdatedMeter getUpdatedMeter() {
            return this._updatedMeter;
        }

        public <E extends Augmentation<UpdateMeterInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._meterRef);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._originalMeter);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode(this._updatedMeter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateMeterInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateMeterInput other = (UpdateMeterInput)obj;
            if (!Objects.equals(this._meterRef, other.getMeterRef())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._originalMeter, other.getOriginalMeter())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals(this._updatedMeter, other.getUpdatedMeter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateMeterInputImpl otherImpl = (UpdateMeterInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateMeterInput>>, Augmentation<UpdateMeterInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UpdateMeterInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._meterRef != null) {
                builder.append("_meterRef=");
                builder.append(this._meterRef);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._originalMeter != null) {
                builder.append("_originalMeter=");
                builder.append(this._originalMeter);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._updatedMeter != null) {
                builder.append("_updatedMeter=");
                builder.append(this._updatedMeter);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

