/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RemoveMeterInputBuilder
implements Builder<RemoveMeterInput> {
    private String _containerName;
    private MeterFlags _flags;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private MeterRef _meterRef;
    private NodeRef _node;
    private Uri _transactionUri;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>> augmentation = Collections.emptyMap();

    public RemoveMeterInputBuilder() {
    }

    public RemoveMeterInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public RemoveMeterInputBuilder(Meter arg) {
        this._flags = arg.getFlags();
        this._meterId = arg.getMeterId();
        this._barrier = arg.isBarrier();
        this._meterName = arg.getMeterName();
        this._containerName = arg.getContainerName();
        this._meterBandHeaders = arg.getMeterBandHeaders();
    }

    public RemoveMeterInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public RemoveMeterInputBuilder(RemoveMeterInput base) {
        AugmentationHolder casted;
        this._containerName = base.getContainerName();
        this._flags = base.getFlags();
        this._meterBandHeaders = base.getMeterBandHeaders();
        this._meterId = base.getMeterId();
        this._meterName = base.getMeterName();
        this._meterRef = base.getMeterRef();
        this._node = base.getNode();
        this._transactionUri = base.getTransactionUri();
        this._barrier = base.isBarrier();
        if (base instanceof RemoveMeterInputImpl) {
            RemoveMeterInputImpl impl = (RemoveMeterInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof Meter) {
            this._flags = ((Meter)arg).getFlags();
            this._meterId = ((Meter)arg).getMeterId();
            this._barrier = ((Meter)arg).isBarrier();
            this._meterName = ((Meter)arg).getMeterName();
            this._containerName = ((Meter)arg).getContainerName();
            this._meterBandHeaders = ((Meter)arg).getMeterBandHeaders();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter] \nbut was: " + arg);
        }
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public MeterRef getMeterRef() {
        return this._meterRef;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<RemoveMeterInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RemoveMeterInputBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public RemoveMeterInputBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public RemoveMeterInputBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    public RemoveMeterInputBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public RemoveMeterInputBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public RemoveMeterInputBuilder setMeterRef(MeterRef value) {
        this._meterRef = value;
        return this;
    }

    public RemoveMeterInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public RemoveMeterInputBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public RemoveMeterInputBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public RemoveMeterInputBuilder addAugmentation(Class<? extends Augmentation<RemoveMeterInput>> augmentationType, Augmentation<RemoveMeterInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RemoveMeterInputBuilder removeAugmentation(Class<? extends Augmentation<RemoveMeterInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RemoveMeterInput build() {
        return new RemoveMeterInputImpl(this);
    }

    private static final class RemoveMeterInputImpl
    implements RemoveMeterInput {
        private final String _containerName;
        private final MeterFlags _flags;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private final MeterRef _meterRef;
        private final NodeRef _node;
        private final Uri _transactionUri;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RemoveMeterInput> getImplementedInterface() {
            return RemoveMeterInput.class;
        }

        private RemoveMeterInputImpl(RemoveMeterInputBuilder base) {
            this._containerName = base.getContainerName();
            this._flags = base.getFlags();
            this._meterBandHeaders = base.getMeterBandHeaders();
            this._meterId = base.getMeterId();
            this._meterName = base.getMeterName();
            this._meterRef = base.getMeterRef();
            this._node = base.getNode();
            this._transactionUri = base.getTransactionUri();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>>(base.augmentation);
                }
            }
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        @Override
        public MeterRef getMeterRef() {
            return this._meterRef;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<RemoveMeterInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._containerName);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._meterBandHeaders);
            result = 31 * result + Objects.hashCode(this._meterId);
            result = 31 * result + Objects.hashCode(this._meterName);
            result = 31 * result + Objects.hashCode(this._meterRef);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode(this._barrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RemoveMeterInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RemoveMeterInput other = (RemoveMeterInput)obj;
            if (!Objects.equals(this._containerName, other.getContainerName())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._meterBandHeaders, other.getMeterBandHeaders())) {
                return false;
            }
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (!Objects.equals(this._meterName, other.getMeterName())) {
                return false;
            }
            if (!Objects.equals(this._meterRef, other.getMeterRef())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals(this._barrier, other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RemoveMeterInputImpl otherImpl = (RemoveMeterInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RemoveMeterInput>>, Augmentation<RemoveMeterInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RemoveMeterInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._containerName != null) {
                builder.append("_containerName=");
                builder.append(this._containerName);
                builder.append(", ");
            }
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._meterBandHeaders != null) {
                builder.append("_meterBandHeaders=");
                builder.append(this._meterBandHeaders);
                builder.append(", ");
            }
            if (this._meterId != null) {
                builder.append("_meterId=");
                builder.append(this._meterId);
                builder.append(", ");
            }
            if (this._meterName != null) {
                builder.append("_meterName=");
                builder.append(this._meterName);
                builder.append(", ");
            }
            if (this._meterRef != null) {
                builder.append("_meterRef=");
                builder.append(this._meterRef);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._barrier != null) {
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

