/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.add.groups.batch.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.add.groups.batch.input.BatchAddGroups;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.add.groups.batch.input.BatchAddGroupsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchAddGroupsBuilder
implements Builder<BatchAddGroups> {
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupTypes _groupType;
    private BatchAddGroupsKey _key;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>> augmentation = Collections.emptyMap();

    public BatchAddGroupsBuilder() {
    }

    public BatchAddGroupsBuilder(Group arg) {
        this._groupType = arg.getGroupType();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._containerName = arg.getContainerName();
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
    }

    public BatchAddGroupsBuilder(BatchAddGroups base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchAddGroupsKey(base.getGroupId());
            this._groupId = base.getGroupId();
        } else {
            this._key = base.getKey();
            this._groupId = this._key.getGroupId();
        }
        this._buckets = base.getBuckets();
        this._containerName = base.getContainerName();
        this._groupName = base.getGroupName();
        this._groupType = base.getGroupType();
        this._barrier = base.isBarrier();
        if (base instanceof BatchAddGroupsImpl) {
            BatchAddGroupsImpl impl = (BatchAddGroupsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Group) {
            this._groupType = ((Group)arg).getGroupType();
            this._groupId = ((Group)arg).getGroupId();
            this._groupName = ((Group)arg).getGroupName();
            this._containerName = ((Group)arg).getContainerName();
            this._barrier = ((Group)arg).isBarrier();
            this._buckets = ((Group)arg).getBuckets();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group] \nbut was: " + arg);
        }
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public BatchAddGroupsKey getKey() {
        return this._key;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<BatchAddGroups>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BatchAddGroupsBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public BatchAddGroupsBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public BatchAddGroupsBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public BatchAddGroupsBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public BatchAddGroupsBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public BatchAddGroupsBuilder setKey(BatchAddGroupsKey value) {
        this._key = value;
        return this;
    }

    public BatchAddGroupsBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public BatchAddGroupsBuilder addAugmentation(Class<? extends Augmentation<BatchAddGroups>> augmentationType, Augmentation<BatchAddGroups> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchAddGroupsBuilder removeAugmentation(Class<? extends Augmentation<BatchAddGroups>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BatchAddGroups build() {
        return new BatchAddGroupsImpl(this);
    }

    private static final class BatchAddGroupsImpl
    implements BatchAddGroups {
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupTypes _groupType;
        private final BatchAddGroupsKey _key;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BatchAddGroups> getImplementedInterface() {
            return BatchAddGroups.class;
        }

        private BatchAddGroupsImpl(BatchAddGroupsBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchAddGroupsKey(base.getGroupId());
                this._groupId = base.getGroupId();
            } else {
                this._key = base.getKey();
                this._groupId = this._key.getGroupId();
            }
            this._buckets = base.getBuckets();
            this._containerName = base.getContainerName();
            this._groupName = base.getGroupName();
            this._groupType = base.getGroupType();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>>(base.augmentation);
                }
            }
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        @Override
        public BatchAddGroupsKey getKey() {
            return this._key;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<BatchAddGroups>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._buckets);
            result = 31 * result + Objects.hashCode(this._containerName);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode(this._groupName);
            result = 31 * result + Objects.hashCode(this._groupType);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._barrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BatchAddGroups.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BatchAddGroups other = (BatchAddGroups)obj;
            if (!Objects.equals(this._buckets, other.getBuckets())) {
                return false;
            }
            if (!Objects.equals(this._containerName, other.getContainerName())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals(this._groupName, other.getGroupName())) {
                return false;
            }
            if (!Objects.equals(this._groupType, other.getGroupType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._barrier, other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchAddGroupsImpl otherImpl = (BatchAddGroupsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BatchAddGroups>>, Augmentation<BatchAddGroups>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BatchAddGroups [";
            StringBuilder builder = new StringBuilder(name);
            if (this._buckets != null) {
                builder.append("_buckets=");
                builder.append(this._buckets);
                builder.append(", ");
            }
            if (this._containerName != null) {
                builder.append("_containerName=");
                builder.append(this._containerName);
                builder.append(", ");
            }
            if (this._groupId != null) {
                builder.append("_groupId=");
                builder.append(this._groupId);
                builder.append(", ");
            }
            if (this._groupName != null) {
                builder.append("_groupName=");
                builder.append(this._groupName);
                builder.append(", ");
            }
            if (this._groupType != null) {
                builder.append("_groupType=");
                builder.append(this._groupType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._barrier != null) {
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

