/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.UpdateGroupsBatchInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.update.groups.batch.input.BatchUpdateGroups;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.BarrierSuffix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateGroupsBatchInputBuilder
implements Builder<UpdateGroupsBatchInput> {
    private List<BatchUpdateGroups> _batchUpdateGroups;
    private NodeRef _node;
    private Boolean _barrierAfter;
    Map<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>> augmentation = Collections.emptyMap();

    public UpdateGroupsBatchInputBuilder() {
    }

    public UpdateGroupsBatchInputBuilder(BarrierSuffix arg) {
        this._barrierAfter = arg.isBarrierAfter();
    }

    public UpdateGroupsBatchInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateGroupsBatchInputBuilder(UpdateGroupsBatchInput base) {
        AugmentationHolder casted;
        this._batchUpdateGroups = base.getBatchUpdateGroups();
        this._node = base.getNode();
        this._barrierAfter = base.isBarrierAfter();
        if (base instanceof UpdateGroupsBatchInputImpl) {
            UpdateGroupsBatchInputImpl impl = (UpdateGroupsBatchInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof BarrierSuffix) {
            this._barrierAfter = ((BarrierSuffix)arg).isBarrierAfter();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.BarrierSuffix] \nbut was: " + arg);
        }
    }

    public List<BatchUpdateGroups> getBatchUpdateGroups() {
        return this._batchUpdateGroups;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Boolean isBarrierAfter() {
        return this._barrierAfter;
    }

    public <E extends Augmentation<UpdateGroupsBatchInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateGroupsBatchInputBuilder setBatchUpdateGroups(List<BatchUpdateGroups> value) {
        this._batchUpdateGroups = value;
        return this;
    }

    public UpdateGroupsBatchInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateGroupsBatchInputBuilder setBarrierAfter(Boolean value) {
        this._barrierAfter = value;
        return this;
    }

    public UpdateGroupsBatchInputBuilder addAugmentation(Class<? extends Augmentation<UpdateGroupsBatchInput>> augmentationType, Augmentation<UpdateGroupsBatchInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateGroupsBatchInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateGroupsBatchInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateGroupsBatchInput build() {
        return new UpdateGroupsBatchInputImpl(this);
    }

    private static final class UpdateGroupsBatchInputImpl
    implements UpdateGroupsBatchInput {
        private final List<BatchUpdateGroups> _batchUpdateGroups;
        private final NodeRef _node;
        private final Boolean _barrierAfter;
        private Map<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateGroupsBatchInput> getImplementedInterface() {
            return UpdateGroupsBatchInput.class;
        }

        private UpdateGroupsBatchInputImpl(UpdateGroupsBatchInputBuilder base) {
            this._batchUpdateGroups = base.getBatchUpdateGroups();
            this._node = base.getNode();
            this._barrierAfter = base.isBarrierAfter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BatchUpdateGroups> getBatchUpdateGroups() {
            return this._batchUpdateGroups;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Boolean isBarrierAfter() {
            return this._barrierAfter;
        }

        public <E extends Augmentation<UpdateGroupsBatchInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchUpdateGroups);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._barrierAfter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateGroupsBatchInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateGroupsBatchInput other = (UpdateGroupsBatchInput)obj;
            if (!Objects.equals(this._batchUpdateGroups, other.getBatchUpdateGroups())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._barrierAfter, other.isBarrierAfter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateGroupsBatchInputImpl otherImpl = (UpdateGroupsBatchInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateGroupsBatchInput>>, Augmentation<UpdateGroupsBatchInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UpdateGroupsBatchInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchUpdateGroups != null) {
                builder.append("_batchUpdateGroups=");
                builder.append(this._batchUpdateGroups);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._barrierAfter != null) {
                builder.append("_barrierAfter=");
                builder.append(this._barrierAfter);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

