/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.AddGroupsBatchInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.groups.service.rev160315.add.groups.batch.input.BatchAddGroups;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.BarrierSuffix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AddGroupsBatchInputBuilder
implements Builder<AddGroupsBatchInput> {
    private List<BatchAddGroups> _batchAddGroups;
    private NodeRef _node;
    private Boolean _barrierAfter;
    Map<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>> augmentation = Collections.emptyMap();

    public AddGroupsBatchInputBuilder() {
    }

    public AddGroupsBatchInputBuilder(BarrierSuffix arg) {
        this._barrierAfter = arg.isBarrierAfter();
    }

    public AddGroupsBatchInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public AddGroupsBatchInputBuilder(AddGroupsBatchInput base) {
        AugmentationHolder casted;
        this._batchAddGroups = base.getBatchAddGroups();
        this._node = base.getNode();
        this._barrierAfter = base.isBarrierAfter();
        if (base instanceof AddGroupsBatchInputImpl) {
            AddGroupsBatchInputImpl impl = (AddGroupsBatchInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof BarrierSuffix) {
            this._barrierAfter = ((BarrierSuffix)arg).isBarrierAfter();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.service.barrier.common.rev160315.BarrierSuffix] \nbut was: " + arg);
        }
    }

    public List<BatchAddGroups> getBatchAddGroups() {
        return this._batchAddGroups;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public Boolean isBarrierAfter() {
        return this._barrierAfter;
    }

    public <E extends Augmentation<AddGroupsBatchInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AddGroupsBatchInputBuilder setBatchAddGroups(List<BatchAddGroups> value) {
        this._batchAddGroups = value;
        return this;
    }

    public AddGroupsBatchInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public AddGroupsBatchInputBuilder setBarrierAfter(Boolean value) {
        this._barrierAfter = value;
        return this;
    }

    public AddGroupsBatchInputBuilder addAugmentation(Class<? extends Augmentation<AddGroupsBatchInput>> augmentationType, Augmentation<AddGroupsBatchInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AddGroupsBatchInputBuilder removeAugmentation(Class<? extends Augmentation<AddGroupsBatchInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AddGroupsBatchInput build() {
        return new AddGroupsBatchInputImpl(this);
    }

    private static final class AddGroupsBatchInputImpl
    implements AddGroupsBatchInput {
        private final List<BatchAddGroups> _batchAddGroups;
        private final NodeRef _node;
        private final Boolean _barrierAfter;
        private Map<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AddGroupsBatchInput> getImplementedInterface() {
            return AddGroupsBatchInput.class;
        }

        private AddGroupsBatchInputImpl(AddGroupsBatchInputBuilder base) {
            this._batchAddGroups = base.getBatchAddGroups();
            this._node = base.getNode();
            this._barrierAfter = base.isBarrierAfter();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>>(base.augmentation);
                }
            }
        }

        @Override
        public List<BatchAddGroups> getBatchAddGroups() {
            return this._batchAddGroups;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public Boolean isBarrierAfter() {
            return this._barrierAfter;
        }

        public <E extends Augmentation<AddGroupsBatchInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchAddGroups);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._barrierAfter);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddGroupsBatchInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AddGroupsBatchInput other = (AddGroupsBatchInput)obj;
            if (!Objects.equals(this._batchAddGroups, other.getBatchAddGroups())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._barrierAfter, other.isBarrierAfter())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AddGroupsBatchInputImpl otherImpl = (AddGroupsBatchInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AddGroupsBatchInput>>, Augmentation<AddGroupsBatchInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "AddGroupsBatchInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchAddGroups != null) {
                builder.append("_batchAddGroups=");
                builder.append(this._batchAddGroups);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._barrierAfter != null) {
                builder.append("_barrierAfter=");
                builder.append(this._barrierAfter);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

