/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.OriginalGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.UpdatedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdateGroupInputBuilder
implements Builder<UpdateGroupInput> {
    private GroupRef _groupRef;
    private NodeRef _node;
    private OriginalGroup _originalGroup;
    private Uri _transactionUri;
    private UpdatedGroup _updatedGroup;
    Map<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> augmentation = Collections.emptyMap();

    public UpdateGroupInputBuilder() {
    }

    public UpdateGroupInputBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public UpdateGroupInputBuilder(GroupUpdate arg) {
        this._originalGroup = arg.getOriginalGroup();
        this._updatedGroup = arg.getUpdatedGroup();
        this._node = arg.getNode();
    }

    public UpdateGroupInputBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public UpdateGroupInputBuilder(UpdateGroupInput base) {
        AugmentationHolder casted;
        this._groupRef = base.getGroupRef();
        this._node = base.getNode();
        this._originalGroup = base.getOriginalGroup();
        this._transactionUri = base.getTransactionUri();
        this._updatedGroup = base.getUpdatedGroup();
        if (base instanceof UpdateGroupInputImpl) {
            UpdateGroupInputImpl impl = (UpdateGroupInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof GroupUpdate) {
            this._originalGroup = ((GroupUpdate)arg).getOriginalGroup();
            this._updatedGroup = ((GroupUpdate)arg).getUpdatedGroup();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdate] \nbut was: " + arg);
        }
    }

    public GroupRef getGroupRef() {
        return this._groupRef;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public OriginalGroup getOriginalGroup() {
        return this._originalGroup;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public UpdatedGroup getUpdatedGroup() {
        return this._updatedGroup;
    }

    public <E extends Augmentation<UpdateGroupInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public UpdateGroupInputBuilder setGroupRef(GroupRef value) {
        this._groupRef = value;
        return this;
    }

    public UpdateGroupInputBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public UpdateGroupInputBuilder setOriginalGroup(OriginalGroup value) {
        this._originalGroup = value;
        return this;
    }

    public UpdateGroupInputBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public UpdateGroupInputBuilder setUpdatedGroup(UpdatedGroup value) {
        this._updatedGroup = value;
        return this;
    }

    public UpdateGroupInputBuilder addAugmentation(Class<? extends Augmentation<UpdateGroupInput>> augmentationType, Augmentation<UpdateGroupInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public UpdateGroupInputBuilder removeAugmentation(Class<? extends Augmentation<UpdateGroupInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UpdateGroupInput build() {
        return new UpdateGroupInputImpl(this);
    }

    private static final class UpdateGroupInputImpl
    implements UpdateGroupInput {
        private final GroupRef _groupRef;
        private final NodeRef _node;
        private final OriginalGroup _originalGroup;
        private final Uri _transactionUri;
        private final UpdatedGroup _updatedGroup;
        private Map<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<UpdateGroupInput> getImplementedInterface() {
            return UpdateGroupInput.class;
        }

        private UpdateGroupInputImpl(UpdateGroupInputBuilder base) {
            this._groupRef = base.getGroupRef();
            this._node = base.getNode();
            this._originalGroup = base.getOriginalGroup();
            this._transactionUri = base.getTransactionUri();
            this._updatedGroup = base.getUpdatedGroup();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>>(base.augmentation);
                }
            }
        }

        @Override
        public GroupRef getGroupRef() {
            return this._groupRef;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public OriginalGroup getOriginalGroup() {
            return this._originalGroup;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        @Override
        public UpdatedGroup getUpdatedGroup() {
            return this._updatedGroup;
        }

        public <E extends Augmentation<UpdateGroupInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._groupRef);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._originalGroup);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode(this._updatedGroup);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UpdateGroupInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UpdateGroupInput other = (UpdateGroupInput)obj;
            if (!Objects.equals(this._groupRef, other.getGroupRef())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._originalGroup, other.getOriginalGroup())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals(this._updatedGroup, other.getUpdatedGroup())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdateGroupInputImpl otherImpl = (UpdateGroupInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UpdateGroupInput>>, Augmentation<UpdateGroupInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "UpdateGroupInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._groupRef != null) {
                builder.append("_groupRef=");
                builder.append(this._groupRef);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._originalGroup != null) {
                builder.append("_originalGroup=");
                builder.append(this._originalGroup);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._updatedGroup != null) {
                builder.append("_updatedGroup=");
                builder.append(this._updatedGroup);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

