/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.GroupUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupUpdatedBuilder
implements Builder<GroupUpdated> {
    private Buckets _buckets;
    private String _containerName;
    private GroupId _groupId;
    private String _groupName;
    private GroupRef _groupRef;
    private GroupTypes _groupType;
    private NodeRef _node;
    private TransactionId _transactionId;
    private Uri _transactionUri;
    private Boolean _barrier;
    Map<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>> augmentation = Collections.emptyMap();

    public GroupUpdatedBuilder() {
    }

    public GroupUpdatedBuilder(Group arg) {
        this._groupType = arg.getGroupType();
        this._groupId = arg.getGroupId();
        this._groupName = arg.getGroupName();
        this._containerName = arg.getContainerName();
        this._barrier = arg.isBarrier();
        this._buckets = arg.getBuckets();
    }

    public GroupUpdatedBuilder(NodeContextRef arg) {
        this._node = arg.getNode();
    }

    public GroupUpdatedBuilder(TransactionMetadata arg) {
        this._transactionUri = arg.getTransactionUri();
    }

    public GroupUpdatedBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public GroupUpdatedBuilder(GroupUpdated base) {
        AugmentationHolder casted;
        this._buckets = base.getBuckets();
        this._containerName = base.getContainerName();
        this._groupId = base.getGroupId();
        this._groupName = base.getGroupName();
        this._groupRef = base.getGroupRef();
        this._groupType = base.getGroupType();
        this._node = base.getNode();
        this._transactionId = base.getTransactionId();
        this._transactionUri = base.getTransactionUri();
        this._barrier = base.isBarrier();
        if (base instanceof GroupUpdatedImpl) {
            GroupUpdatedImpl impl = (GroupUpdatedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeContextRef) {
            this._node = ((NodeContextRef)arg).getNode();
            isValidArg = true;
        }
        if (arg instanceof TransactionMetadata) {
            this._transactionUri = ((TransactionMetadata)arg).getTransactionUri();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (arg instanceof Group) {
            this._groupType = ((Group)arg).getGroupType();
            this._groupId = ((Group)arg).getGroupId();
            this._groupName = ((Group)arg).getGroupName();
            this._containerName = ((Group)arg).getContainerName();
            this._barrier = ((Group)arg).isBarrier();
            this._buckets = ((Group)arg).getBuckets();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeContextRef, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionMetadata, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware, org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group] \nbut was: " + arg);
        }
    }

    public Buckets getBuckets() {
        return this._buckets;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public GroupRef getGroupRef() {
        return this._groupRef;
    }

    public GroupTypes getGroupType() {
        return this._groupType;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public Uri getTransactionUri() {
        return this._transactionUri;
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public <E extends Augmentation<GroupUpdated>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupUpdatedBuilder setBuckets(Buckets value) {
        this._buckets = value;
        return this;
    }

    public GroupUpdatedBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public GroupUpdatedBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupUpdatedBuilder setGroupName(String value) {
        this._groupName = value;
        return this;
    }

    public GroupUpdatedBuilder setGroupRef(GroupRef value) {
        this._groupRef = value;
        return this;
    }

    public GroupUpdatedBuilder setGroupType(GroupTypes value) {
        this._groupType = value;
        return this;
    }

    public GroupUpdatedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    public GroupUpdatedBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public GroupUpdatedBuilder setTransactionUri(Uri value) {
        this._transactionUri = value;
        return this;
    }

    public GroupUpdatedBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public GroupUpdatedBuilder addAugmentation(Class<? extends Augmentation<GroupUpdated>> augmentationType, Augmentation<GroupUpdated> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupUpdatedBuilder removeAugmentation(Class<? extends Augmentation<GroupUpdated>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GroupUpdated build() {
        return new GroupUpdatedImpl(this);
    }

    private static final class GroupUpdatedImpl
    implements GroupUpdated {
        private final Buckets _buckets;
        private final String _containerName;
        private final GroupId _groupId;
        private final String _groupName;
        private final GroupRef _groupRef;
        private final GroupTypes _groupType;
        private final NodeRef _node;
        private final TransactionId _transactionId;
        private final Uri _transactionUri;
        private final Boolean _barrier;
        private Map<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GroupUpdated> getImplementedInterface() {
            return GroupUpdated.class;
        }

        private GroupUpdatedImpl(GroupUpdatedBuilder base) {
            this._buckets = base.getBuckets();
            this._containerName = base.getContainerName();
            this._groupId = base.getGroupId();
            this._groupName = base.getGroupName();
            this._groupRef = base.getGroupRef();
            this._groupType = base.getGroupType();
            this._node = base.getNode();
            this._transactionId = base.getTransactionId();
            this._transactionUri = base.getTransactionUri();
            this._barrier = base.isBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>>(base.augmentation);
                }
            }
        }

        public Buckets getBuckets() {
            return this._buckets;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public GroupId getGroupId() {
            return this._groupId;
        }

        public String getGroupName() {
            return this._groupName;
        }

        @Override
        public GroupRef getGroupRef() {
            return this._groupRef;
        }

        public GroupTypes getGroupType() {
            return this._groupType;
        }

        public NodeRef getNode() {
            return this._node;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public Uri getTransactionUri() {
            return this._transactionUri;
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public <E extends Augmentation<GroupUpdated>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._buckets);
            result = 31 * result + Objects.hashCode(this._containerName);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode(this._groupName);
            result = 31 * result + Objects.hashCode(this._groupRef);
            result = 31 * result + Objects.hashCode(this._groupType);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode(this._transactionUri);
            result = 31 * result + Objects.hashCode(this._barrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GroupUpdated.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GroupUpdated other = (GroupUpdated)obj;
            if (!Objects.equals(this._buckets, other.getBuckets())) {
                return false;
            }
            if (!Objects.equals(this._containerName, other.getContainerName())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals(this._groupName, other.getGroupName())) {
                return false;
            }
            if (!Objects.equals(this._groupRef, other.getGroupRef())) {
                return false;
            }
            if (!Objects.equals(this._groupType, other.getGroupType())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals(this._transactionUri, other.getTransactionUri())) {
                return false;
            }
            if (!Objects.equals(this._barrier, other.isBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GroupUpdatedImpl otherImpl = (GroupUpdatedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GroupUpdated>>, Augmentation<GroupUpdated>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GroupUpdated [";
            StringBuilder builder = new StringBuilder(name);
            if (this._buckets != null) {
                builder.append("_buckets=");
                builder.append(this._buckets);
                builder.append(", ");
            }
            if (this._containerName != null) {
                builder.append("_containerName=");
                builder.append(this._containerName);
                builder.append(", ");
            }
            if (this._groupId != null) {
                builder.append("_groupId=");
                builder.append(this._groupId);
                builder.append(", ");
            }
            if (this._groupName != null) {
                builder.append("_groupName=");
                builder.append(this._groupName);
                builder.append(", ");
            }
            if (this._groupRef != null) {
                builder.append("_groupRef=");
                builder.append(this._groupRef);
                builder.append(", ");
            }
            if (this._groupType != null) {
                builder.append("_groupType=");
                builder.append(this._groupType);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._transactionUri != null) {
                builder.append("_transactionUri=");
                builder.append(this._transactionUri);
                builder.append(", ");
            }
            if (this._barrier != null) {
                builder.append("_barrier=");
                builder.append(this._barrier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

