/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.update.flows.batch.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowIdGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowInputUpdateGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.input.update.grouping.OriginalBatchedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.input.update.grouping.UpdatedBatchedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.update.flows.batch.input.BatchUpdateFlows;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.update.flows.batch.input.BatchUpdateFlowsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchUpdateFlowsBuilder
implements Builder<BatchUpdateFlows> {
    private FlowId _flowId;
    private BatchUpdateFlowsKey _key;
    private OriginalBatchedFlow _originalBatchedFlow;
    private UpdatedBatchedFlow _updatedBatchedFlow;
    Map<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>> augmentation = Collections.emptyMap();

    public BatchUpdateFlowsBuilder() {
    }

    public BatchUpdateFlowsBuilder(BatchFlowInputUpdateGrouping arg) {
        this._originalBatchedFlow = arg.getOriginalBatchedFlow();
        this._updatedBatchedFlow = arg.getUpdatedBatchedFlow();
        this._flowId = arg.getFlowId();
    }

    public BatchUpdateFlowsBuilder(BatchFlowIdGrouping arg) {
        this._flowId = arg.getFlowId();
    }

    public BatchUpdateFlowsBuilder(BatchUpdateFlows base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchUpdateFlowsKey(base.getFlowId());
            this._flowId = base.getFlowId();
        } else {
            this._key = base.getKey();
            this._flowId = this._key.getFlowId();
        }
        this._originalBatchedFlow = base.getOriginalBatchedFlow();
        this._updatedBatchedFlow = base.getUpdatedBatchedFlow();
        if (base instanceof BatchUpdateFlowsImpl) {
            BatchUpdateFlowsImpl impl = (BatchUpdateFlowsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchFlowInputUpdateGrouping) {
            this._originalBatchedFlow = ((BatchFlowInputUpdateGrouping)arg).getOriginalBatchedFlow();
            this._updatedBatchedFlow = ((BatchFlowInputUpdateGrouping)arg).getUpdatedBatchedFlow();
            isValidArg = true;
        }
        if (arg instanceof BatchFlowIdGrouping) {
            this._flowId = ((BatchFlowIdGrouping)arg).getFlowId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowInputUpdateGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowIdGrouping] \nbut was: " + arg);
        }
    }

    public FlowId getFlowId() {
        return this._flowId;
    }

    public BatchUpdateFlowsKey getKey() {
        return this._key;
    }

    public OriginalBatchedFlow getOriginalBatchedFlow() {
        return this._originalBatchedFlow;
    }

    public UpdatedBatchedFlow getUpdatedBatchedFlow() {
        return this._updatedBatchedFlow;
    }

    public <E extends Augmentation<BatchUpdateFlows>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BatchUpdateFlowsBuilder setFlowId(FlowId value) {
        this._flowId = value;
        return this;
    }

    public BatchUpdateFlowsBuilder setKey(BatchUpdateFlowsKey value) {
        this._key = value;
        return this;
    }

    public BatchUpdateFlowsBuilder setOriginalBatchedFlow(OriginalBatchedFlow value) {
        this._originalBatchedFlow = value;
        return this;
    }

    public BatchUpdateFlowsBuilder setUpdatedBatchedFlow(UpdatedBatchedFlow value) {
        this._updatedBatchedFlow = value;
        return this;
    }

    public BatchUpdateFlowsBuilder addAugmentation(Class<? extends Augmentation<BatchUpdateFlows>> augmentationType, Augmentation<BatchUpdateFlows> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchUpdateFlowsBuilder removeAugmentation(Class<? extends Augmentation<BatchUpdateFlows>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BatchUpdateFlows build() {
        return new BatchUpdateFlowsImpl(this);
    }

    private static final class BatchUpdateFlowsImpl
    implements BatchUpdateFlows {
        private final FlowId _flowId;
        private final BatchUpdateFlowsKey _key;
        private final OriginalBatchedFlow _originalBatchedFlow;
        private final UpdatedBatchedFlow _updatedBatchedFlow;
        private Map<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BatchUpdateFlows> getImplementedInterface() {
            return BatchUpdateFlows.class;
        }

        private BatchUpdateFlowsImpl(BatchUpdateFlowsBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchUpdateFlowsKey(base.getFlowId());
                this._flowId = base.getFlowId();
            } else {
                this._key = base.getKey();
                this._flowId = this._key.getFlowId();
            }
            this._originalBatchedFlow = base.getOriginalBatchedFlow();
            this._updatedBatchedFlow = base.getUpdatedBatchedFlow();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>>(base.augmentation);
                }
            }
        }

        @Override
        public FlowId getFlowId() {
            return this._flowId;
        }

        @Override
        public BatchUpdateFlowsKey getKey() {
            return this._key;
        }

        @Override
        public OriginalBatchedFlow getOriginalBatchedFlow() {
            return this._originalBatchedFlow;
        }

        @Override
        public UpdatedBatchedFlow getUpdatedBatchedFlow() {
            return this._updatedBatchedFlow;
        }

        public <E extends Augmentation<BatchUpdateFlows>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flowId);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._originalBatchedFlow);
            result = 31 * result + Objects.hashCode(this._updatedBatchedFlow);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BatchUpdateFlows.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BatchUpdateFlows other = (BatchUpdateFlows)obj;
            if (!Objects.equals(this._flowId, other.getFlowId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._originalBatchedFlow, other.getOriginalBatchedFlow())) {
                return false;
            }
            if (!Objects.equals(this._updatedBatchedFlow, other.getUpdatedBatchedFlow())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchUpdateFlowsImpl otherImpl = (BatchUpdateFlowsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BatchUpdateFlows>>, Augmentation<BatchUpdateFlows>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BatchUpdateFlows [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flowId != null) {
                builder.append("_flowId=");
                builder.append(this._flowId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._originalBatchedFlow != null) {
                builder.append("_originalBatchedFlow=");
                builder.append(this._originalBatchedFlow);
                builder.append(", ");
            }
            if (this._updatedBatchedFlow != null) {
                builder.append("_updatedBatchedFlow=");
                builder.append(this._updatedBatchedFlow);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

