/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.output.list.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowIdGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.output.list.grouping.BatchFailedFlowsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.batch.flow.output.list.grouping.BatchFailedFlowsOutputKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BatchFailedFlowsOutputBuilder
implements Builder<BatchFailedFlowsOutput> {
    private Integer _batchOrder;
    private FlowId _flowId;
    private BatchFailedFlowsOutputKey _key;
    Map<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>> augmentation = Collections.emptyMap();

    public BatchFailedFlowsOutputBuilder() {
    }

    public BatchFailedFlowsOutputBuilder(BatchOrderGrouping arg) {
        this._batchOrder = arg.getBatchOrder();
    }

    public BatchFailedFlowsOutputBuilder(BatchFlowIdGrouping arg) {
        this._flowId = arg.getFlowId();
    }

    public BatchFailedFlowsOutputBuilder(BatchFailedFlowsOutput base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new BatchFailedFlowsOutputKey(base.getBatchOrder());
            this._batchOrder = base.getBatchOrder();
        } else {
            this._key = base.getKey();
            this._batchOrder = this._key.getBatchOrder();
        }
        this._flowId = base.getFlowId();
        if (base instanceof BatchFailedFlowsOutputImpl) {
            BatchFailedFlowsOutputImpl impl = (BatchFailedFlowsOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BatchOrderGrouping) {
            this._batchOrder = ((BatchOrderGrouping)arg).getBatchOrder();
            isValidArg = true;
        }
        if (arg instanceof BatchFlowIdGrouping) {
            this._flowId = ((BatchFlowIdGrouping)arg).getFlowId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.service.batch.common.rev160322.BatchOrderGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.flows.service.rev160314.BatchFlowIdGrouping] \nbut was: " + arg);
        }
    }

    public Integer getBatchOrder() {
        return this._batchOrder;
    }

    public FlowId getFlowId() {
        return this._flowId;
    }

    public BatchFailedFlowsOutputKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<BatchFailedFlowsOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBatchOrderRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public BatchFailedFlowsOutputBuilder setBatchOrder(Integer value) {
        if (value != null) {
            BatchFailedFlowsOutputBuilder.checkBatchOrderRange(value);
        }
        this._batchOrder = value;
        return this;
    }

    public BatchFailedFlowsOutputBuilder setFlowId(FlowId value) {
        this._flowId = value;
        return this;
    }

    public BatchFailedFlowsOutputBuilder setKey(BatchFailedFlowsOutputKey value) {
        this._key = value;
        return this;
    }

    public BatchFailedFlowsOutputBuilder addAugmentation(Class<? extends Augmentation<BatchFailedFlowsOutput>> augmentationType, Augmentation<BatchFailedFlowsOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BatchFailedFlowsOutputBuilder removeAugmentation(Class<? extends Augmentation<BatchFailedFlowsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public BatchFailedFlowsOutput build() {
        return new BatchFailedFlowsOutputImpl(this);
    }

    private static final class BatchFailedFlowsOutputImpl
    implements BatchFailedFlowsOutput {
        private final Integer _batchOrder;
        private final FlowId _flowId;
        private final BatchFailedFlowsOutputKey _key;
        private Map<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BatchFailedFlowsOutput> getImplementedInterface() {
            return BatchFailedFlowsOutput.class;
        }

        private BatchFailedFlowsOutputImpl(BatchFailedFlowsOutputBuilder base) {
            if (base.getKey() == null) {
                this._key = new BatchFailedFlowsOutputKey(base.getBatchOrder());
                this._batchOrder = base.getBatchOrder();
            } else {
                this._key = base.getKey();
                this._batchOrder = this._key.getBatchOrder();
            }
            this._flowId = base.getFlowId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBatchOrder() {
            return this._batchOrder;
        }

        @Override
        public FlowId getFlowId() {
            return this._flowId;
        }

        @Override
        public BatchFailedFlowsOutputKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<BatchFailedFlowsOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._batchOrder);
            result = 31 * result + Objects.hashCode(this._flowId);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BatchFailedFlowsOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BatchFailedFlowsOutput other = (BatchFailedFlowsOutput)obj;
            if (!Objects.equals(this._batchOrder, other.getBatchOrder())) {
                return false;
            }
            if (!Objects.equals(this._flowId, other.getFlowId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BatchFailedFlowsOutputImpl otherImpl = (BatchFailedFlowsOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BatchFailedFlowsOutput>>, Augmentation<BatchFailedFlowsOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BatchFailedFlowsOutput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._batchOrder != null) {
                builder.append("_batchOrder=");
                builder.append(this._batchOrder);
                builder.append(", ");
            }
            if (this._flowId != null) {
                builder.append("_flowId=");
                builder.append(this._flowId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

