/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowTableRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowCookie;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowModRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.GenericFlowAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.RemovedFlowReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.mod.removed.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SwitchFlowRemovedBuilder
implements Builder<SwitchFlowRemoved> {
    private BigInteger _byteCount;
    private FlowCookie _cookie;
    private Long _durationNsec;
    private Long _durationSec;
    private FlowTableRef _flowTable;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private Match _match;
    private NodeRef _node;
    private BigInteger _packetCount;
    private Integer _priority;
    private RemovedFlowReason _removedReason;
    private Short _tableId;
    Map<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKBYTECOUNTRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPACKETCOUNTRANGE_RANGES;

    public SwitchFlowRemovedBuilder() {
    }

    public SwitchFlowRemovedBuilder(NodeFlowRemoved arg) {
        this._node = arg.getNode();
        this._flowTable = arg.getFlowTable();
        this._removedReason = arg.getRemovedReason();
        this._durationNsec = arg.getDurationNsec();
        this._durationSec = arg.getDurationSec();
        this._packetCount = arg.getPacketCount();
        this._byteCount = arg.getByteCount();
        this._match = arg.getMatch();
        this._priority = arg.getPriority();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._cookie = arg.getCookie();
        this._tableId = arg.getTableId();
    }

    public SwitchFlowRemovedBuilder(FlowModRemoved arg) {
        this._removedReason = arg.getRemovedReason();
        this._durationNsec = arg.getDurationNsec();
        this._durationSec = arg.getDurationSec();
        this._packetCount = arg.getPacketCount();
        this._byteCount = arg.getByteCount();
        this._match = arg.getMatch();
        this._priority = arg.getPriority();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._cookie = arg.getCookie();
        this._tableId = arg.getTableId();
    }

    public SwitchFlowRemovedBuilder(GenericFlowAttributes arg) {
        this._priority = arg.getPriority();
        this._idleTimeout = arg.getIdleTimeout();
        this._hardTimeout = arg.getHardTimeout();
        this._cookie = arg.getCookie();
        this._tableId = arg.getTableId();
    }

    public SwitchFlowRemovedBuilder(SwitchFlowRemoved base) {
        AugmentationHolder casted;
        this._byteCount = base.getByteCount();
        this._cookie = base.getCookie();
        this._durationNsec = base.getDurationNsec();
        this._durationSec = base.getDurationSec();
        this._flowTable = base.getFlowTable();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._match = base.getMatch();
        this._node = base.getNode();
        this._packetCount = base.getPacketCount();
        this._priority = base.getPriority();
        this._removedReason = base.getRemovedReason();
        this._tableId = base.getTableId();
        if (base instanceof SwitchFlowRemovedImpl) {
            SwitchFlowRemovedImpl impl = (SwitchFlowRemovedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeFlowRemoved) {
            this._node = ((NodeFlowRemoved)arg).getNode();
            this._flowTable = ((NodeFlowRemoved)arg).getFlowTable();
            isValidArg = true;
        }
        if (arg instanceof FlowModRemoved) {
            this._removedReason = ((FlowModRemoved)arg).getRemovedReason();
            this._durationNsec = ((FlowModRemoved)arg).getDurationNsec();
            this._durationSec = ((FlowModRemoved)arg).getDurationSec();
            this._packetCount = ((FlowModRemoved)arg).getPacketCount();
            this._byteCount = ((FlowModRemoved)arg).getByteCount();
            this._match = ((FlowModRemoved)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof GenericFlowAttributes) {
            this._priority = ((GenericFlowAttributes)arg).getPriority();
            this._idleTimeout = ((GenericFlowAttributes)arg).getIdleTimeout();
            this._hardTimeout = ((GenericFlowAttributes)arg).getHardTimeout();
            this._cookie = ((GenericFlowAttributes)arg).getCookie();
            this._tableId = ((GenericFlowAttributes)arg).getTableId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeFlowRemoved, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowModRemoved, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.GenericFlowAttributes] \nbut was: " + arg);
        }
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public FlowCookie getCookie() {
        return this._cookie;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public FlowTableRef getFlowTable() {
        return this._flowTable;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public Match getMatch() {
        return this._match;
    }

    public NodeRef getNode() {
        return this._node;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public RemovedFlowReason getRemovedReason() {
        return this._removedReason;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<SwitchFlowRemoved>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkByteCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKBYTECOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKBYTECOUNTRANGE_RANGES)));
    }

    public SwitchFlowRemovedBuilder setByteCount(BigInteger value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkByteCountRange(value);
        }
        this._byteCount = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setCookie(FlowCookie value) {
        this._cookie = value;
        return this;
    }

    private static void checkDurationNsecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SwitchFlowRemovedBuilder setDurationNsec(Long value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkDurationNsecRange(value);
        }
        this._durationNsec = value;
        return this;
    }

    private static void checkDurationSecRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SwitchFlowRemovedBuilder setDurationSec(Long value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkDurationSecRange(value);
        }
        this._durationSec = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setFlowTable(FlowTableRef value) {
        this._flowTable = value;
        return this;
    }

    private static void checkHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SwitchFlowRemovedBuilder setHardTimeout(Integer value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkHardTimeoutRange(value);
        }
        this._hardTimeout = value;
        return this;
    }

    private static void checkIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SwitchFlowRemovedBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkIdleTimeoutRange(value);
        }
        this._idleTimeout = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setNode(NodeRef value) {
        this._node = value;
        return this;
    }

    private static void checkPacketCountRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPACKETCOUNTRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPACKETCOUNTRANGE_RANGES)));
    }

    public SwitchFlowRemovedBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkPacketCountRange(value);
        }
        this._packetCount = value;
        return this;
    }

    private static void checkPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SwitchFlowRemovedBuilder setPriority(Integer value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    public SwitchFlowRemovedBuilder setRemovedReason(RemovedFlowReason value) {
        this._removedReason = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public SwitchFlowRemovedBuilder setTableId(Short value) {
        if (value != null) {
            SwitchFlowRemovedBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public SwitchFlowRemovedBuilder addAugmentation(Class<? extends Augmentation<SwitchFlowRemoved>> augmentationType, Augmentation<SwitchFlowRemoved> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SwitchFlowRemovedBuilder removeAugmentation(Class<? extends Augmentation<SwitchFlowRemoved>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SwitchFlowRemoved build() {
        return new SwitchFlowRemovedImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKBYTECOUNTRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPACKETCOUNTRANGE_RANGES = a;
    }

    private static final class SwitchFlowRemovedImpl
    implements SwitchFlowRemoved {
        private final BigInteger _byteCount;
        private final FlowCookie _cookie;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final FlowTableRef _flowTable;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final Match _match;
        private final NodeRef _node;
        private final BigInteger _packetCount;
        private final Integer _priority;
        private final RemovedFlowReason _removedReason;
        private final Short _tableId;
        private Map<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SwitchFlowRemoved> getImplementedInterface() {
            return SwitchFlowRemoved.class;
        }

        private SwitchFlowRemovedImpl(SwitchFlowRemovedBuilder base) {
            this._byteCount = base.getByteCount();
            this._cookie = base.getCookie();
            this._durationNsec = base.getDurationNsec();
            this._durationSec = base.getDurationSec();
            this._flowTable = base.getFlowTable();
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._match = base.getMatch();
            this._node = base.getNode();
            this._packetCount = base.getPacketCount();
            this._priority = base.getPriority();
            this._removedReason = base.getRemovedReason();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>>(base.augmentation);
                }
            }
        }

        public BigInteger getByteCount() {
            return this._byteCount;
        }

        public FlowCookie getCookie() {
            return this._cookie;
        }

        public Long getDurationNsec() {
            return this._durationNsec;
        }

        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public FlowTableRef getFlowTable() {
            return this._flowTable;
        }

        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        public Match getMatch() {
            return this._match;
        }

        @Override
        public NodeRef getNode() {
            return this._node;
        }

        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        public Integer getPriority() {
            return this._priority;
        }

        public RemovedFlowReason getRemovedReason() {
            return this._removedReason;
        }

        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<SwitchFlowRemoved>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._byteCount);
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Objects.hashCode(this._durationNsec);
            result = 31 * result + Objects.hashCode(this._durationSec);
            result = 31 * result + Objects.hashCode(this._flowTable);
            result = 31 * result + Objects.hashCode(this._hardTimeout);
            result = 31 * result + Objects.hashCode(this._idleTimeout);
            result = 31 * result + Objects.hashCode(this._match);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._packetCount);
            result = 31 * result + Objects.hashCode(this._priority);
            result = 31 * result + Objects.hashCode(this._removedReason);
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SwitchFlowRemoved.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SwitchFlowRemoved other = (SwitchFlowRemoved)obj;
            if (!Objects.equals(this._byteCount, other.getByteCount())) {
                return false;
            }
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Objects.equals(this._durationNsec, other.getDurationNsec())) {
                return false;
            }
            if (!Objects.equals(this._durationSec, other.getDurationSec())) {
                return false;
            }
            if (!Objects.equals(this._flowTable, other.getFlowTable())) {
                return false;
            }
            if (!Objects.equals(this._hardTimeout, other.getHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._idleTimeout, other.getIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._match, other.getMatch())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._packetCount, other.getPacketCount())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals(this._removedReason, other.getRemovedReason())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SwitchFlowRemovedImpl otherImpl = (SwitchFlowRemovedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SwitchFlowRemoved>>, Augmentation<SwitchFlowRemoved>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SwitchFlowRemoved [";
            StringBuilder builder = new StringBuilder(name);
            if (this._byteCount != null) {
                builder.append("_byteCount=");
                builder.append(this._byteCount);
                builder.append(", ");
            }
            if (this._cookie != null) {
                builder.append("_cookie=");
                builder.append(this._cookie);
                builder.append(", ");
            }
            if (this._durationNsec != null) {
                builder.append("_durationNsec=");
                builder.append(this._durationNsec);
                builder.append(", ");
            }
            if (this._durationSec != null) {
                builder.append("_durationSec=");
                builder.append(this._durationSec);
                builder.append(", ");
            }
            if (this._flowTable != null) {
                builder.append("_flowTable=");
                builder.append(this._flowTable);
                builder.append(", ");
            }
            if (this._hardTimeout != null) {
                builder.append("_hardTimeout=");
                builder.append(this._hardTimeout);
                builder.append(", ");
            }
            if (this._idleTimeout != null) {
                builder.append("_idleTimeout=");
                builder.append(this._idleTimeout);
                builder.append(", ");
            }
            if (this._match != null) {
                builder.append("_match=");
                builder.append(this._match);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._packetCount != null) {
                builder.append("_packetCount=");
                builder.append(this._packetCount);
                builder.append(", ");
            }
            if (this._priority != null) {
                builder.append("_priority=");
                builder.append(this._priority);
                builder.append(", ");
            }
            if (this._removedReason != null) {
                builder.append("_removedReason=");
                builder.append(this._removedReason);
                builder.append(", ");
            }
            if (this._tableId != null) {
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

