/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ExperimenterErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.NodeExperimenterErrorNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeExperimenterErrorNotificationBuilder
implements Builder<NodeExperimenterErrorNotification> {
    private String _data;
    private Integer _expType;
    private Long _experimenterId;
    private TransactionId _transactionId;
    private ErrorType _type;
    Map<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>> augmentation = Collections.emptyMap();

    public NodeExperimenterErrorNotificationBuilder() {
    }

    public NodeExperimenterErrorNotificationBuilder(TransactionAware arg) {
        this._transactionId = arg.getTransactionId();
    }

    public NodeExperimenterErrorNotificationBuilder(ExperimenterErrorMessage arg) {
        this._type = arg.getType();
        this._expType = arg.getExpType();
        this._experimenterId = arg.getExperimenterId();
        this._data = arg.getData();
    }

    public NodeExperimenterErrorNotificationBuilder(NodeExperimenterErrorNotification base) {
        AugmentationHolder casted;
        this._data = base.getData();
        this._expType = base.getExpType();
        this._experimenterId = base.getExperimenterId();
        this._transactionId = base.getTransactionId();
        this._type = base.getType();
        if (base instanceof NodeExperimenterErrorNotificationImpl) {
            NodeExperimenterErrorNotificationImpl impl = (NodeExperimenterErrorNotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ExperimenterErrorMessage) {
            this._type = ((ExperimenterErrorMessage)arg).getType();
            this._expType = ((ExperimenterErrorMessage)arg).getExpType();
            this._experimenterId = ((ExperimenterErrorMessage)arg).getExperimenterId();
            this._data = ((ExperimenterErrorMessage)arg).getData();
            isValidArg = true;
        }
        if (arg instanceof TransactionAware) {
            this._transactionId = ((TransactionAware)arg).getTransactionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.errors.rev131116.ExperimenterErrorMessage, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev150304.TransactionAware] \nbut was: " + arg);
        }
    }

    public String getData() {
        return this._data;
    }

    public Integer getExpType() {
        return this._expType;
    }

    public Long getExperimenterId() {
        return this._experimenterId;
    }

    public TransactionId getTransactionId() {
        return this._transactionId;
    }

    public ErrorType getType() {
        return this._type;
    }

    public <E extends Augmentation<NodeExperimenterErrorNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeExperimenterErrorNotificationBuilder setData(String value) {
        this._data = value;
        return this;
    }

    private static void checkExpTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NodeExperimenterErrorNotificationBuilder setExpType(Integer value) {
        if (value != null) {
            NodeExperimenterErrorNotificationBuilder.checkExpTypeRange(value);
        }
        this._expType = value;
        return this;
    }

    private static void checkExperimenterIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NodeExperimenterErrorNotificationBuilder setExperimenterId(Long value) {
        if (value != null) {
            NodeExperimenterErrorNotificationBuilder.checkExperimenterIdRange(value);
        }
        this._experimenterId = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder setTransactionId(TransactionId value) {
        this._transactionId = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder setType(ErrorType value) {
        this._type = value;
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder addAugmentation(Class<? extends Augmentation<NodeExperimenterErrorNotification>> augmentationType, Augmentation<NodeExperimenterErrorNotification> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeExperimenterErrorNotificationBuilder removeAugmentation(Class<? extends Augmentation<NodeExperimenterErrorNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeExperimenterErrorNotification build() {
        return new NodeExperimenterErrorNotificationImpl(this);
    }

    private static final class NodeExperimenterErrorNotificationImpl
    implements NodeExperimenterErrorNotification {
        private final String _data;
        private final Integer _expType;
        private final Long _experimenterId;
        private final TransactionId _transactionId;
        private final ErrorType _type;
        private Map<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NodeExperimenterErrorNotification> getImplementedInterface() {
            return NodeExperimenterErrorNotification.class;
        }

        private NodeExperimenterErrorNotificationImpl(NodeExperimenterErrorNotificationBuilder base) {
            this._data = base.getData();
            this._expType = base.getExpType();
            this._experimenterId = base.getExperimenterId();
            this._transactionId = base.getTransactionId();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>>(base.augmentation);
                }
            }
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public Integer getExpType() {
            return this._expType;
        }

        @Override
        public Long getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public TransactionId getTransactionId() {
            return this._transactionId;
        }

        @Override
        public ErrorType getType() {
            return this._type;
        }

        public <E extends Augmentation<NodeExperimenterErrorNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._data);
            result = 31 * result + Objects.hashCode(this._expType);
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._transactionId);
            result = 31 * result + Objects.hashCode((Object)this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeExperimenterErrorNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NodeExperimenterErrorNotification other = (NodeExperimenterErrorNotification)obj;
            if (!Objects.equals(this._data, other.getData())) {
                return false;
            }
            if (!Objects.equals(this._expType, other.getExpType())) {
                return false;
            }
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._transactionId, other.getTransactionId())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeExperimenterErrorNotificationImpl otherImpl = (NodeExperimenterErrorNotificationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NodeExperimenterErrorNotification>>, Augmentation<NodeExperimenterErrorNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NodeExperimenterErrorNotification [";
            StringBuilder builder = new StringBuilder(name);
            if (this._data != null) {
                builder.append("_data=");
                builder.append(this._data);
                builder.append(", ");
            }
            if (this._expType != null) {
                builder.append("_expType=");
                builder.append(this._expType);
                builder.append(", ");
            }
            if (this._experimenterId != null) {
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
                builder.append(", ");
            }
            if (this._transactionId != null) {
                builder.append("_transactionId=");
                builder.append(this._transactionId);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append((Object)this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

