/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.StaleFlow;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableBuilder
implements Builder<Table> {
    private List<Flow> _flow;
    private Short _id;
    private TableKey _key;
    private List<StaleFlow> _staleFlow;
    Map<Class<? extends Augmentation<Table>>, Augmentation<Table>> augmentation = Collections.emptyMap();

    public TableBuilder() {
    }

    public TableBuilder(Table base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new TableKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._flow = base.getFlow();
        this._staleFlow = base.getStaleFlow();
        if (base instanceof TableImpl) {
            TableImpl impl = (TableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>(casted.augmentations());
        }
    }

    public List<Flow> getFlow() {
        return this._flow;
    }

    public Short getId() {
        return this._id;
    }

    public TableKey getKey() {
        return this._key;
    }

    public List<StaleFlow> getStaleFlow() {
        return this._staleFlow;
    }

    public <E extends Augmentation<Table>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableBuilder setFlow(List<Flow> value) {
        this._flow = value;
        return this;
    }

    private static void checkIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public TableBuilder setId(Short value) {
        if (value != null) {
            TableBuilder.checkIdRange(value);
        }
        this._id = value;
        return this;
    }

    public TableBuilder setKey(TableKey value) {
        this._key = value;
        return this;
    }

    public TableBuilder setStaleFlow(List<StaleFlow> value) {
        this._staleFlow = value;
        return this;
    }

    public TableBuilder addAugmentation(Class<? extends Augmentation<Table>> augmentationType, Augmentation<Table> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableBuilder removeAugmentation(Class<? extends Augmentation<Table>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Table build() {
        return new TableImpl(this);
    }

    private static final class TableImpl
    implements Table {
        private final List<Flow> _flow;
        private final Short _id;
        private final TableKey _key;
        private final List<StaleFlow> _staleFlow;
        private Map<Class<? extends Augmentation<Table>>, Augmentation<Table>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Table> getImplementedInterface() {
            return Table.class;
        }

        private TableImpl(TableBuilder base) {
            if (base.getKey() == null) {
                this._key = new TableKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._flow = base.getFlow();
            this._staleFlow = base.getStaleFlow();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Table>>, Augmentation<Table>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Table>>, Augmentation<Table>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Flow> getFlow() {
            return this._flow;
        }

        @Override
        public Short getId() {
            return this._id;
        }

        @Override
        public TableKey getKey() {
            return this._key;
        }

        @Override
        public List<StaleFlow> getStaleFlow() {
            return this._staleFlow;
        }

        public <E extends Augmentation<Table>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flow);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._staleFlow);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Table.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Table other = (Table)obj;
            if (!Objects.equals(this._flow, other.getFlow())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._staleFlow, other.getStaleFlow())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TableImpl otherImpl = (TableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Table>>, Augmentation<Table>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Table [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flow != null) {
                builder.append("_flow=");
                builder.append(this._flow);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._staleFlow != null) {
                builder.append("_staleFlow=");
                builder.append(this._staleFlow);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

