/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.nodes.node.table.FlowHashIdMapKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowHashIdMapBuilder
implements Builder<FlowHashIdMap> {
    private FlowId _flowId;
    private String _hash;
    private FlowHashIdMapKey _key;
    Map<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> augmentation = Collections.emptyMap();

    public FlowHashIdMapBuilder() {
    }

    public FlowHashIdMapBuilder(FlowHashIdMap base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FlowHashIdMapKey(base.getHash());
            this._hash = base.getHash();
        } else {
            this._key = base.getKey();
            this._hash = this._key.getHash();
        }
        this._flowId = base.getFlowId();
        if (base instanceof FlowHashIdMapImpl) {
            FlowHashIdMapImpl impl = (FlowHashIdMapImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>(casted.augmentations());
        }
    }

    public FlowId getFlowId() {
        return this._flowId;
    }

    public String getHash() {
        return this._hash;
    }

    public FlowHashIdMapKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<FlowHashIdMap>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowHashIdMapBuilder setFlowId(FlowId value) {
        this._flowId = value;
        return this;
    }

    public FlowHashIdMapBuilder setHash(String value) {
        this._hash = value;
        return this;
    }

    public FlowHashIdMapBuilder setKey(FlowHashIdMapKey value) {
        this._key = value;
        return this;
    }

    public FlowHashIdMapBuilder addAugmentation(Class<? extends Augmentation<FlowHashIdMap>> augmentationType, Augmentation<FlowHashIdMap> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowHashIdMapBuilder removeAugmentation(Class<? extends Augmentation<FlowHashIdMap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowHashIdMap build() {
        return new FlowHashIdMapImpl(this);
    }

    private static final class FlowHashIdMapImpl
    implements FlowHashIdMap {
        private final FlowId _flowId;
        private final String _hash;
        private final FlowHashIdMapKey _key;
        private Map<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowHashIdMap> getImplementedInterface() {
            return FlowHashIdMap.class;
        }

        private FlowHashIdMapImpl(FlowHashIdMapBuilder base) {
            if (base.getKey() == null) {
                this._key = new FlowHashIdMapKey(base.getHash());
                this._hash = base.getHash();
            } else {
                this._key = base.getKey();
                this._hash = this._key.getHash();
            }
            this._flowId = base.getFlowId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>>(base.augmentation);
                }
            }
        }

        @Override
        public FlowId getFlowId() {
            return this._flowId;
        }

        @Override
        public String getHash() {
            return this._hash;
        }

        @Override
        public FlowHashIdMapKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<FlowHashIdMap>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flowId);
            result = 31 * result + Objects.hashCode(this._hash);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowHashIdMap.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowHashIdMap other = (FlowHashIdMap)obj;
            if (!Objects.equals(this._flowId, other.getFlowId())) {
                return false;
            }
            if (!Objects.equals(this._hash, other.getHash())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowHashIdMapImpl otherImpl = (FlowHashIdMapImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowHashIdMap>>, Augmentation<FlowHashIdMap>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlowHashIdMap [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flowId != null) {
                builder.append("_flowId=");
                builder.append(this._flowId);
                builder.append(", ");
            }
            if (this._hash != null) {
                builder.append("_hash=");
                builder.append(this._hash);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

